/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.FixedSizeSet;

public abstract class AnnotationsDirectory {
    public static final AnnotationsDirectory EMPTY = new AnnotationsDirectory(){

        @Override
        public int getFieldAnnotationCount() {
            return 0;
        }

        @Override
        @Nonnull
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            return ImmutableSet.of();
        }

        @Override
        @Nonnull
        public AnnotationIterator getFieldAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }

        @Override
        @Nonnull
        public AnnotationIterator getMethodAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }

        @Override
        @Nonnull
        public AnnotationIterator getParameterAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }
    };

    public abstract int getFieldAnnotationCount();

    @Nonnull
    public abstract Set<? extends DexBackedAnnotation> getClassAnnotations();

    @Nonnull
    public abstract AnnotationIterator getFieldAnnotationIterator();

    @Nonnull
    public abstract AnnotationIterator getMethodAnnotationIterator();

    @Nonnull
    public abstract AnnotationIterator getParameterAnnotationIterator();

    @Nonnull
    public static AnnotationsDirectory newOrEmpty(@Nonnull DexBackedDexFile dexFile, int directoryAnnotationsOffset) {
        if (directoryAnnotationsOffset == 0) {
            return EMPTY;
        }
        return new AnnotationsDirectoryImpl(dexFile, directoryAnnotationsOffset);
    }

    @Nonnull
    public static Set<? extends DexBackedAnnotation> getAnnotations(final @Nonnull DexBackedDexFile dexFile, final int annotationSetOffset) {
        if (annotationSetOffset != 0) {
            final int size2 = dexFile.readSmallUint(annotationSetOffset);
            return new FixedSizeSet<DexBackedAnnotation>(){

                @Override
                @Nonnull
                public DexBackedAnnotation readItem(int index) {
                    int annotationOffset = dexFile.readSmallUint(annotationSetOffset + 4 + 4 * index);
                    return new DexBackedAnnotation(dexFile, annotationOffset);
                }

                @Override
                public int size() {
                    return size2;
                }
            };
        }
        return ImmutableSet.of();
    }

    @Nonnull
    public static List<Set<? extends DexBackedAnnotation>> getParameterAnnotations(final @Nonnull DexBackedDexFile dexFile, final int annotationSetListOffset) {
        if (annotationSetListOffset > 0) {
            final int size2 = dexFile.readSmallUint(annotationSetListOffset);
            return new FixedSizeList<Set<? extends DexBackedAnnotation>>(){

                @Override
                @Nonnull
                public Set<? extends DexBackedAnnotation> readItem(int index) {
                    int annotationSetOffset = dexFile.readSmallUint(annotationSetListOffset + 4 + index * 4);
                    return AnnotationsDirectory.getAnnotations(dexFile, annotationSetOffset);
                }

                @Override
                public int size() {
                    return size2;
                }
            };
        }
        return ImmutableList.of();
    }

    private static class AnnotationsDirectoryImpl
    extends AnnotationsDirectory {
        @Nonnull
        public final DexBackedDexFile dexFile;
        private final int directoryOffset;
        private static final int FIELD_COUNT_OFFSET = 4;
        private static final int METHOD_COUNT_OFFSET = 8;
        private static final int PARAMETER_COUNT_OFFSET = 12;
        private static final int ANNOTATIONS_START_OFFSET = 16;
        private static final int FIELD_ANNOTATION_SIZE = 8;
        private static final int METHOD_ANNOTATION_SIZE = 8;

        public AnnotationsDirectoryImpl(@Nonnull DexBackedDexFile dexFile, int directoryOffset) {
            this.dexFile = dexFile;
            this.directoryOffset = directoryOffset;
        }

        @Override
        public int getFieldAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 4);
        }

        public int getMethodAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 8);
        }

        public int getParameterAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 12);
        }

        @Override
        @Nonnull
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            return AnnotationsDirectoryImpl.getAnnotations(this.dexFile, this.dexFile.readSmallUint(this.directoryOffset));
        }

        @Override
        @Nonnull
        public AnnotationIterator getFieldAnnotationIterator() {
            int fieldAnnotationCount = this.getFieldAnnotationCount();
            if (fieldAnnotationCount == 0) {
                return AnnotationIterator.EMPTY;
            }
            return new AnnotationIteratorImpl(this.directoryOffset + 16, fieldAnnotationCount);
        }

        @Override
        @Nonnull
        public AnnotationIterator getMethodAnnotationIterator() {
            int methodCount = this.getMethodAnnotationCount();
            if (methodCount == 0) {
                return AnnotationIterator.EMPTY;
            }
            int fieldCount = this.getFieldAnnotationCount();
            int methodAnnotationsOffset = this.directoryOffset + 16 + fieldCount * 8;
            return new AnnotationIteratorImpl(methodAnnotationsOffset, methodCount);
        }

        @Override
        @Nonnull
        public AnnotationIterator getParameterAnnotationIterator() {
            int parameterAnnotationCount = this.getParameterAnnotationCount();
            if (parameterAnnotationCount == 0) {
                return AnnotationIterator.EMPTY;
            }
            int fieldCount = this.getFieldAnnotationCount();
            int methodCount = this.getMethodAnnotationCount();
            int parameterAnnotationsOffset = this.directoryOffset + 16 + fieldCount * 8 + methodCount * 8;
            return new AnnotationIteratorImpl(parameterAnnotationsOffset, parameterAnnotationCount);
        }

        private class AnnotationIteratorImpl
        implements AnnotationIterator {
            private final int startOffset;
            private final int size;
            private int currentIndex;
            private int currentItemIndex;

            public AnnotationIteratorImpl(int startOffset, int size2) {
                this.startOffset = startOffset;
                this.size = size2;
                this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(startOffset);
                this.currentIndex = 0;
            }

            @Override
            public int seekTo(int itemIndex) {
                while (this.currentItemIndex < itemIndex && this.currentIndex + 1 < this.size) {
                    ++this.currentIndex;
                    this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset + this.currentIndex * 8);
                }
                if (this.currentItemIndex == itemIndex) {
                    return AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset + this.currentIndex * 8 + 4);
                }
                return 0;
            }

            @Override
            public void reset() {
                this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset);
                this.currentIndex = 0;
            }
        }
    }

    public static interface AnnotationIterator {
        public static final AnnotationIterator EMPTY = new AnnotationIterator(){

            @Override
            public int seekTo(int key2) {
                return 0;
            }

            @Override
            public void reset() {
            }
        };

        public int seekTo(int var1);

        public void reset();
    }
}

