/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;

public abstract class BuilderOffsetInstruction
extends BuilderInstruction
implements OffsetInstruction {
    @Nonnull
    protected final Label target;

    public BuilderOffsetInstruction(@Nonnull Opcode opcode, @Nonnull Label target) {
        super(opcode);
        this.target = target;
    }

    @Override
    public int getCodeOffset() {
        int codeOffset = this.internalGetCodeOffset();
        if (this.getCodeUnits() == 1 && (codeOffset < -128 || codeOffset > 127) || this.getCodeUnits() == 2 && (codeOffset < Short.MIN_VALUE || codeOffset > Short.MAX_VALUE)) {
            throw new IllegalStateException("Target is out of range");
        }
        return codeOffset;
    }

    int internalGetCodeOffset() {
        return this.target.getCodeAddress() - this.getLocation().getCodeAddress();
    }

    @Nonnull
    public Label getTarget() {
        return this.target;
    }
}

