/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.timeout;

import org.jboss.util.timeout.TimeoutExt;
import org.jboss.util.timeout.TimeoutPriorityQueue;
import org.jboss.util.timeout.TimeoutTarget;

public class TimeoutPriorityQueueImpl
implements TimeoutPriorityQueue {
    private Object lock = new Object();
    private int size = 0;
    private TimeoutExtImpl[] queue = new TimeoutExtImpl[16];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeoutExt offer(long time, TimeoutTarget target) {
        if (this.queue == null) {
            throw new IllegalStateException("TimeoutPriorityQueue has been cancelled");
        }
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        if (target == null) {
            throw new IllegalArgumentException("Null timeout target");
        }
        Object object = this.lock;
        synchronized (object) {
            if (++this.size == this.queue.length) {
                TimeoutExtImpl[] newQ = new TimeoutExtImpl[2 * this.queue.length];
                System.arraycopy(this.queue, 0, newQ, 0, this.queue.length);
                this.queue = newQ;
            }
            TimeoutExtImpl timeout = this.queue[this.size] = new TimeoutExtImpl();
            timeout.index = this.size;
            timeout.time = time;
            timeout.target = target;
            this.normalizeUp(this.size);
            if (timeout.index == 1) {
                this.lock.notify();
            }
            return timeout;
        }
    }

    @Override
    public TimeoutExt take() {
        return this.poll(-1L);
    }

    @Override
    public TimeoutExt poll() {
        return this.poll(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeoutExt poll(long wait) {
        long endWait = -1L;
        if (wait > 0L) {
            endWait = System.currentTimeMillis() + wait;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.queue != null && (wait >= 0L || endWait == -1L)) {
                block15: {
                    if (this.size == 0) {
                        try {
                            if (endWait == -1L) {
                                this.lock.wait();
                                break block15;
                            }
                            this.lock.wait(wait);
                        }
                        catch (InterruptedException ex) {}
                    } else {
                        long now = System.currentTimeMillis();
                        if (this.queue[1].time > now) {
                            long waitForFirst = this.queue[1].time - now;
                            if (endWait != -1L && waitForFirst > wait) {
                                waitForFirst = wait;
                            }
                            try {
                                this.lock.wait(waitForFirst);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                        }
                        if (this.size > 0 && this.queue != null && this.queue[1].time <= System.currentTimeMillis()) {
                            TimeoutExtImpl result2 = this.removeNode(1);
                            result2.index = -2;
                            return result2;
                        }
                    }
                }
                if (endWait == -1L) continue;
                wait = endWait - System.currentTimeMillis();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeoutExt peek() {
        Object object = this.lock;
        synchronized (object) {
            if (this.size > 0) {
                return this.queue[1];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(TimeoutExt timeout) {
        TimeoutExtImpl timeoutImpl = (TimeoutExtImpl)timeout;
        Object object = this.lock;
        synchronized (object) {
            if (timeoutImpl.index > 0) {
                this.removeNode(timeoutImpl.index);
                timeoutImpl.index = -1;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue == null) {
                return;
            }
            for (int i = 1; i <= this.size; ++i) {
                this.queue[i] = this.cleanupTimeoutExtImpl(this.queue[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue == null) {
                return;
            }
            this.clear();
            this.queue = null;
            this.size = 0;
            this.lock.notifyAll();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean isCancelled() {
        return this.queue == null;
    }

    private boolean normalizeUp(int index) {
        if (index == 1) {
            return false;
        }
        boolean ret = false;
        long t = this.queue[index].time;
        int p = index >> 1;
        while (this.queue[p].time > t) {
            this.swap(p, index);
            ret = true;
            if (p == 1) break;
            index = p;
            p >>= 1;
        }
        return ret;
    }

    private void swap(int a2, int b) {
        TimeoutExtImpl temp = this.queue[a2];
        this.queue[a2] = this.queue[b];
        this.queue[a2].index = a2;
        this.queue[b] = temp;
        this.queue[b].index = b;
    }

    private TimeoutExtImpl removeNode(int index) {
        TimeoutExtImpl res = this.queue[index];
        if (index == this.size) {
            --this.size;
            this.queue[index] = null;
            return res;
        }
        this.swap(index, this.size);
        --this.size;
        this.queue[res.index] = null;
        if (this.normalizeUp(index)) {
            return res;
        }
        long t = this.queue[index].time;
        int c = index << 1;
        while (c <= this.size) {
            TimeoutExtImpl l = this.queue[c];
            if (c + 1 <= this.size) {
                TimeoutExtImpl r = this.queue[c + 1];
                if (l.time <= r.time) {
                    if (t <= l.time) break;
                    this.swap(index, c);
                    index = c;
                } else {
                    if (t <= r.time) break;
                    this.swap(index, c + 1);
                    index = c + 1;
                }
            } else {
                if (t <= l.time) break;
                this.swap(index, c);
                index = c;
            }
            c = index << 1;
        }
        return res;
    }

    private TimeoutExtImpl cleanupTimeoutExtImpl(TimeoutExtImpl timeout) {
        if (timeout != null) {
            timeout.target = null;
        }
        return null;
    }

    void checkTree() {
        this.assertExpr(this.size >= 0);
        this.assertExpr(this.size < this.queue.length);
        this.assertExpr(this.queue[0] == null);
        if (this.size > 0) {
            int i;
            this.assertExpr(this.queue[1] != null);
            this.assertExpr(this.queue[1].index == 1);
            for (i = 2; i <= this.size; ++i) {
                this.assertExpr(this.queue[i] != null);
                this.assertExpr(this.queue[i].index == i);
                this.assertExpr(this.queue[i >> 1].time <= this.queue[i].time);
            }
            for (i = this.size + 1; i < this.queue.length; ++i) {
                this.assertExpr(this.queue[i] == null);
            }
        }
    }

    private void assertExpr(boolean expr) {
        if (!expr) {
            throw new IllegalStateException("***** assert failed *****");
        }
    }

    private class TimeoutExtImpl
    implements TimeoutExt {
        static final int DONE = -1;
        static final int TIMEOUT = -2;
        int index;
        long time;
        TimeoutTarget target;

        private TimeoutExtImpl() {
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public TimeoutTarget getTimeoutTarget() {
            return this.target;
        }

        @Override
        public void done() {
            this.index = -1;
        }

        @Override
        public boolean cancel() {
            return TimeoutPriorityQueueImpl.this.remove(this);
        }
    }
}

