/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.logging.Logger;

public final class Streams {
    private static final Logger log = Logger.getLogger(Streams.class);
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static boolean close(InputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success2 = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success2 = false;
        }
        return success2;
    }

    public static boolean close(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success2 = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success2 = false;
        }
        return success2;
    }

    public static boolean close(Object stream) {
        boolean success2 = false;
        if (stream instanceof InputStream) {
            success2 = Streams.close((InputStream)stream);
        } else if (stream instanceof OutputStream) {
            success2 = Streams.close((OutputStream)stream);
        } else {
            throw new IllegalArgumentException("stream is not an InputStream or OutputStream");
        }
        return success2;
    }

    public static boolean close(InputStream[] streams) {
        boolean success2 = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.close(streams[i]);
            if (rv) continue;
            success2 = false;
        }
        return success2;
    }

    public static boolean close(OutputStream[] streams) {
        boolean success2 = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.close(streams[i]);
            if (rv) continue;
            success2 = false;
        }
        return success2;
    }

    public static boolean close(Object[] streams) {
        boolean success2 = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.close(streams[i]);
            if (rv) continue;
            success2 = false;
        }
        return success2;
    }

    public static boolean fclose(OutputStream stream) {
        return Streams.flush(stream) && Streams.close(stream);
    }

    public static boolean fclose(OutputStream[] streams) {
        boolean success2 = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.fclose(streams[i]);
            if (rv) continue;
            success2 = false;
        }
        return success2;
    }

    public static boolean flush(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success2 = true;
        try {
            stream.flush();
        }
        catch (IOException e) {
            success2 = false;
        }
        return success2;
    }

    public static boolean flush(OutputStream[] streams) {
        boolean success2 = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.flush(streams[i]);
            if (rv) continue;
            success2 = false;
        }
        return success2;
    }

    public static long copy(InputStream input2, OutputStream output, byte[] buffer) throws IOException {
        int read2;
        long total = 0L;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("copying " + input2 + " to " + output + " with buffer size: " + buffer.length));
        }
        while ((read2 = input2.read(buffer)) != -1) {
            output.write(buffer, 0, read2);
            total += (long)read2;
            if (!trace) continue;
            log.trace((Object)("bytes read: " + read2 + "; total bytes read: " + total));
        }
        return total;
    }

    public static long copy(InputStream input2, OutputStream output, int size2) throws IOException {
        return Streams.copy(input2, output, new byte[size2]);
    }

    public static long copy(InputStream input2, OutputStream output) throws IOException {
        return Streams.copy(input2, output, 2048);
    }

    public static long copyb(InputStream input2, OutputStream output) throws IOException {
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        if (!(output instanceof BufferedOutputStream)) {
            output = new BufferedOutputStream(output);
        }
        long bytes = Streams.copy(input2, output, 2048);
        output.flush();
        return bytes;
    }

    public static long copySome(InputStream input2, OutputStream output, byte[] buffer, long length2) throws IOException {
        int read2;
        long total = 0L;
        boolean trace = log.isTraceEnabled();
        int readLength = Math.min((int)length2, buffer.length);
        if (trace) {
            log.trace((Object)("initial read length: " + readLength));
        }
        while (readLength != 0 && (read2 = input2.read(buffer, 0, readLength)) != -1) {
            if (trace) {
                log.trace((Object)("read bytes: " + read2));
            }
            output.write(buffer, 0, read2);
            total += (long)read2;
            if (trace) {
                log.trace((Object)("total bytes read: " + total));
            }
            readLength = Math.min((int)(length2 - total), buffer.length);
            if (!trace) continue;
            log.trace((Object)("next read length: " + readLength));
        }
        return total;
    }

    public static long copySome(InputStream input2, OutputStream output, int size2, long length2) throws IOException {
        return Streams.copySome(input2, output, new byte[size2], length2);
    }

    public static long copySome(InputStream input2, OutputStream output, long length2) throws IOException {
        return Streams.copySome(input2, output, 2048, length2);
    }
}

