/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jboss.util.NullArgumentException;
import org.jboss.util.property.BoundPropertyListener;
import org.jboss.util.property.PropertyMap;

public class PropertyGroup
extends PropertyMap {
    private static final long serialVersionUID = -2557641199743063159L;
    protected final String basename;

    public PropertyGroup(String basename, Properties container2) {
        super(container2);
        if (basename == null) {
            throw new NullArgumentException("basename");
        }
        this.basename = basename;
    }

    public final String getBaseName() {
        return this.basename;
    }

    private String makePropertyName(String suffix) {
        return this.basename + "." + suffix;
    }

    private String makePropertyName(Object suffix) {
        return this.makePropertyName(String.valueOf(suffix));
    }

    @Override
    public boolean containsKey(Object name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.containsKey(this.makePropertyName(name));
    }

    @Override
    public Object put(Object name, Object value2) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.put(this.makePropertyName(name), value2);
    }

    @Override
    public Object get(Object name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.get(this.makePropertyName(name));
    }

    @Override
    public Object remove(Object name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.remove(this.makePropertyName(name));
    }

    @Override
    public Set entrySet() {
        final Set superSet = super.entrySet(true);
        return new AbstractSet(){

            private boolean isInGroup(Map.Entry entry2) {
                String key2 = (String)entry2.getKey();
                return key2.startsWith(PropertyGroup.this.basename);
            }

            @Override
            public int size() {
                Iterator iter2 = superSet.iterator();
                int count2 = 0;
                while (iter2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iter2.next();
                    if (!this.isInGroup(entry2)) continue;
                    ++count2;
                }
                return count2;
            }

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    private Iterator iter;
                    private Object next;
                    {
                        this.iter = superSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.next == null && this.iter.hasNext()) {
                            Map.Entry entry2 = (Map.Entry)this.iter.next();
                            if (!this.isInGroup(entry2)) continue;
                            this.next = entry2;
                            return true;
                        }
                        return false;
                    }

                    public Object next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Object obj = this.next;
                        this.next = null;
                        return obj;
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    @Override
    protected void addPropertyListener(BoundPropertyListener listener) {
        String name = this.makePropertyName(listener.getPropertyName());
        ArrayList<BoundPropertyListener> list = (ArrayList<BoundPropertyListener>)this.boundListeners.get(name);
        if (list == null) {
            list = new ArrayList<BoundPropertyListener>();
            this.boundListeners.put(name, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
            listener.propertyBound(this);
        }
    }

    @Override
    protected boolean removePropertyListener(BoundPropertyListener listener) {
        String name = this.makePropertyName(listener.getPropertyName());
        List list = (List)this.boundListeners.get(name);
        boolean removed = false;
        if (list != null && (removed = list.remove(listener))) {
            listener.propertyUnbound(this);
        }
        return removed;
    }
}

