/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SoftSet
implements Set {
    private HashMap map = new HashMap();
    private ReferenceQueue gcqueue = new ReferenceQueue();

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.processQueue();
        Integer key2 = new Integer(o.hashCode());
        boolean contains2 = this.map.containsKey(key2);
        return contains2;
    }

    @Override
    public Iterator iterator() {
        this.processQueue();
        Iterator theIter = this.map.values().iterator();
        return new ComparableSoftReferenceIterator(theIter);
    }

    @Override
    public Object[] toArray() {
        this.processQueue();
        return this.toArray(new Object[0]);
    }

    @Override
    public Object[] toArray(Object[] a2) {
        this.processQueue();
        int size2 = this.map.size();
        Object[] array = new Object[]{};
        if (a2.length >= size2) {
            array = a2;
        }
        Iterator iter2 = this.map.values().iterator();
        int index = 0;
        while (iter2.hasNext()) {
            ComparableSoftReference csr = (ComparableSoftReference)iter2.next();
            Object value2 = csr.get();
            if (array.length == 0) {
                if (value2 == null) {
                    ++index;
                    continue;
                }
                Array.newInstance(value2.getClass(), size2);
            }
            array[index] = value2;
            ++index;
        }
        return array;
    }

    @Override
    public boolean add(Object o) {
        this.processQueue();
        Integer key2 = new Integer(o.hashCode());
        ComparableSoftReference sr = new ComparableSoftReference(key2, o, this.gcqueue);
        return this.map.put(key2, sr) == null;
    }

    @Override
    public boolean remove(Object o) {
        this.processQueue();
        Integer key2 = new Integer(o.hashCode());
        return this.map.remove(key2) != null;
    }

    @Override
    public boolean containsAll(Collection c) {
        this.processQueue();
        Iterator iter2 = c.iterator();
        boolean contains2 = true;
        while (iter2.hasNext()) {
            Object value2 = iter2.next();
            Integer key2 = new Integer(value2.hashCode());
            contains2 &= this.map.containsKey(key2);
        }
        return contains2;
    }

    @Override
    public boolean addAll(Collection c) {
        this.processQueue();
        Iterator iter2 = c.iterator();
        boolean added = false;
        while (iter2.hasNext()) {
            ComparableSoftReference sr;
            Object value2 = iter2.next();
            Integer key2 = new Integer(value2.hashCode());
            added |= this.map.put(key2, sr = new ComparableSoftReference(key2, value2, this.gcqueue)) == null;
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection c) {
        Iterator iter2 = this.iterator();
        boolean removed = false;
        while (iter2.hasNext()) {
            Object value2 = iter2.next();
            if (c.contains(value2)) continue;
            iter2.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection c) {
        this.processQueue();
        Iterator iter2 = c.iterator();
        boolean removed = false;
        while (iter2.hasNext()) {
            Object value2 = iter2.next();
            removed |= this.remove(value2);
        }
        return removed;
    }

    @Override
    public void clear() {
        while (this.gcqueue.poll() != null) {
        }
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private void processQueue() {
        ComparableSoftReference cr;
        while ((cr = (ComparableSoftReference)this.gcqueue.poll()) != null) {
            this.map.remove(cr.getKey());
        }
    }

    static class ComparableSoftReferenceIterator
    implements Iterator {
        Iterator theIter;

        ComparableSoftReferenceIterator(Iterator theIter) {
            this.theIter = theIter;
        }

        @Override
        public boolean hasNext() {
            return this.theIter.hasNext();
        }

        public Object next() {
            ComparableSoftReference csr = (ComparableSoftReference)this.theIter.next();
            return csr.get();
        }

        @Override
        public void remove() {
            this.theIter.remove();
        }
    }

    static class ComparableSoftReference
    extends SoftReference {
        private Integer key;

        ComparableSoftReference(Integer key2, Object o, ReferenceQueue q) {
            super(o, q);
            this.key = key2;
        }

        Integer getKey() {
            return this.key;
        }
    }
}

