/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jboss.util.Null;

public final class Iterators {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public static Iterator forEnumeration(Enumeration enumeration) {
        return new Enum2Iterator(enumeration);
    }

    public static Enumeration toEnumeration(Iterator iter2) {
        return new Iter2Enumeration(iter2);
    }

    public static Iterator makeImmutable(Iterator iter2) {
        return new ImmutableIterator(iter2);
    }

    public static Iterator makeSynchronized(Iterator iter2) {
        return new SyncIterator(iter2);
    }

    public static Enumeration makeSynchronized(Enumeration enumeration) {
        return new SyncEnumeration(enumeration);
    }

    public static Iterator union(Iterator[] iters) {
        HashMap map2 = new HashMap();
        for (int i = 0; i < iters.length; ++i) {
            if (iters[i] == null) continue;
            while (iters[i].hasNext()) {
                Object obj = iters[i].next();
                if (map2.containsKey(obj)) continue;
                map2.put(obj, Null.VALUE);
            }
        }
        return map2.keySet().iterator();
    }

    public static String toString(Iterator iter2, String delim) {
        StringBuffer buff = new StringBuffer();
        while (iter2.hasNext()) {
            buff.append(iter2.next());
            if (!iter2.hasNext()) continue;
            buff.append(delim);
        }
        return buff.toString();
    }

    public static String toString(Iterator iter2) {
        return Iterators.toString(iter2, ",");
    }

    private static final class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("no more elements");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("no more elements");
        }
    }

    private static final class SyncEnumeration
    implements Enumeration {
        private final Enumeration enumeration;

        public SyncEnumeration(Enumeration enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public synchronized boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        public synchronized Object nextElement() {
            return this.enumeration.nextElement();
        }
    }

    private static final class SyncIterator
    implements Iterator {
        private final Iterator iter;

        public SyncIterator(Iterator iter2) {
            this.iter = iter2;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.iter.hasNext();
        }

        public synchronized Object next() {
            return this.iter.next();
        }

        @Override
        public synchronized void remove() {
            this.iter.remove();
        }
    }

    private static final class ImmutableIterator
    implements Iterator {
        private final Iterator iter;

        public ImmutableIterator(Iterator iter2) {
            this.iter = iter2;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("iterator is immutable");
        }
    }

    private static final class Iter2Enumeration
    implements Enumeration {
        private final Iterator iter;

        public Iter2Enumeration(Iterator iter2) {
            this.iter = iter2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }

    private static final class Enum2Iterator
    implements Iterator {
        private final Enumeration enumeration;

        public Enum2Iterator(Enumeration enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        public Object next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Enumerations are immutable");
        }
    }
}

