/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.Executable;
import org.jboss.util.Heap;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.TimerTask;
import org.jboss.util.WorkerQueue;

public class TimerQueue
extends WorkerQueue {
    private Heap m_heap = new Heap();

    public TimerQueue() {
        this("TimerTask Thread");
    }

    public TimerQueue(String threadName) {
        super(threadName);
    }

    public void schedule(TimerTask t) {
        this.schedule(t, 0L);
    }

    public void schedule(TimerTask t, long delay) {
        if (t == null) {
            throw new IllegalArgumentException("Can't schedule a null TimerTask");
        }
        if (delay < 0L) {
            delay = 0L;
        }
        t.setNextExecutionTime(System.currentTimeMillis() + delay);
        this.putJob(t);
    }

    @Override
    protected void putJobImpl(Executable task) {
        this.m_heap.insert(task);
        ((TimerTask)task).setState(2);
        this.notifyAll();
    }

    @Override
    protected Executable getJobImpl() throws InterruptedException {
        while (this.m_heap.peek() == null) {
            this.wait();
        }
        TimerTask task = (TimerTask)this.m_heap.extract();
        switch (task.getState()) {
            case 3: 
            case 4: {
                task = null;
                return this.getJobImpl();
            }
            case 1: 
            case 2: {
                return task;
            }
        }
        throw new IllegalStateException("TimerTask has an illegal state");
    }

    @Override
    protected Runnable createQueueLoop() {
        return new TimerTaskLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear() {
        super.clear();
        TimerQueue timerQueue = this;
        synchronized (timerQueue) {
            this.m_heap.clear();
        }
    }

    protected class TimerTaskLoop
    implements Runnable {
        protected TimerTaskLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                block9: while (true) {
                    while (true) {
                        try {
                            while (true) {
                                boolean runTask;
                                TimerTask task = (TimerTask)TimerQueue.this.getJob();
                                long now = System.currentTimeMillis();
                                long executionTime = task.getNextExecutionTime();
                                long timeToWait = executionTime - now;
                                boolean bl = runTask = timeToWait <= 0L;
                                if (!runTask) {
                                    TimerQueue mutex;
                                    TimerQueue.this.putJob(task);
                                    TimerQueue timerQueue = mutex = TimerQueue.this;
                                    synchronized (timerQueue) {
                                        mutex.wait(timeToWait);
                                        continue block9;
                                    }
                                }
                                if (task.isPeriodic()) {
                                    task.setNextExecutionTime(executionTime + task.getPeriod());
                                    TimerQueue.this.putJob(task);
                                } else {
                                    task.setState(3);
                                }
                                task.execute();
                            }
                        }
                        catch (InterruptedException x) {
                            break block15;
                        }
                        catch (Exception e) {
                            ThrowableHandler.add(1, e);
                            continue;
                        }
                        break;
                    }
                    break;
                }
                finally {
                    TimerQueue.this.clear();
                }
            }
        }
    }
}

