/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.util.CharacterChecker;
import org.jboss.util.EmptyStringException;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.NullArgumentException;

public final class Strings {
    public static final String EMPTY = "";
    private static final long MSEC = 1L;
    private static final long SECS = 1000L;
    private static final long MINS = 60000L;
    private static final long HOUR = 3600000L;
    private static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"};
    private static final String[] ejbQlIdentifiers = new String[]{"AND", "AS", "BETWEEN", "DISTINCT", "EMPTY", "FALSE", "FROM", "IN", "IS", "LIKE", "MEMBER", "NOT", "NULL", "OBJECT", "OF", "OR", "SELECT", "UNKNOWN", "TRUE", "WHERE"};

    public static String subst(StringBuffer buff, String from2, String to2, String string2) {
        int begin = 0;
        int end = 0;
        while ((end = string2.indexOf(from2, end)) != -1) {
            buff.append(string2.substring(begin, end));
            buff.append(to2);
            end = begin = end + from2.length();
        }
        buff.append(string2.substring(begin, string2.length()));
        return buff.toString();
    }

    public static String subst(String from2, String to2, String string2) {
        return Strings.subst(new StringBuffer(), from2, to2, string2);
    }

    public static String subst(StringBuffer buff, String string2, Map map2, String beginToken, String endToken) {
        Range range2;
        int begin = 0;
        int rangeEnd = 0;
        while ((range2 = Strings.rangeOf(beginToken, endToken, string2, rangeEnd)) != null) {
            buff.append(string2.substring(begin, range2.begin));
            String key2 = string2.substring(range2.begin + beginToken.length(), range2.end);
            Object value2 = map2.get(key2);
            if (value2 == null) {
                value2 = EMPTY;
            }
            buff.append(value2);
            rangeEnd = begin = range2.end + endToken.length();
        }
        buff.append(string2.substring(begin, string2.length()));
        return buff.toString();
    }

    public static String subst(String string2, Map map2, String beginToken, String endToken) {
        return Strings.subst(new StringBuffer(), string2, map2, beginToken, endToken);
    }

    public static String subst(StringBuffer buff, String string2, String[] replace, char token) {
        int i = string2.length();
        for (int j = 0; j >= 0 && j < i; ++j) {
            char c = string2.charAt(j);
            if (c == token) {
                if (j == i) continue;
                int k = Character.digit(string2.charAt(j + 1), 10);
                if (k == -1) {
                    buff.append(string2.charAt(j + 1));
                } else if (k < replace.length) {
                    buff.append(replace[k]);
                }
                ++j;
                continue;
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static String subst(String string2, String[] replace, char token) {
        return Strings.subst(new StringBuffer(), string2, replace, token);
    }

    public static String subst(String string2, String[] replace) {
        return Strings.subst(new StringBuffer(), string2, replace, '%');
    }

    public static Range rangeOf(String beginToken, String endToken, String string2, int fromIndex) {
        int end;
        int begin = string2.indexOf(beginToken, fromIndex);
        if (begin != -1 && (end = string2.indexOf(endToken, begin + 1)) != -1) {
            return new Range(begin, end);
        }
        return null;
    }

    public static Range rangeOf(String beginToken, String endToken, String string2) {
        return Strings.rangeOf(beginToken, endToken, string2, 0);
    }

    public static String[] split(String string2, String delim, int limit) {
        int count2 = Strings.count(string2, delim) + 1;
        if (limit > 0 && count2 > limit) {
            count2 = limit;
        }
        String[] strings = new String[count2];
        int begin = 0;
        for (int i = 0; i < count2; ++i) {
            int end = string2.indexOf(delim, begin);
            if (end == -1 || i + 1 == count2) {
                end = string2.length();
            }
            strings[i] = end == 0 ? EMPTY : string2.substring(begin, end);
            begin = end + 1;
        }
        return strings;
    }

    public static String[] split(String string2, String delim) {
        return Strings.split(string2, delim, -1);
    }

    public static String join(StringBuffer buff, Object[] array, String delim) {
        boolean haveDelim = delim != null;
        for (int i = 0; i < array.length; ++i) {
            buff.append(array[i]);
            if (!haveDelim || i + 1 >= array.length) continue;
            buff.append(delim);
        }
        return buff.toString();
    }

    public static String join(Object[] array, String delim) {
        return Strings.join(new StringBuffer(), array, delim);
    }

    public static String join(Object[] array) {
        return Strings.join(array, null);
    }

    public static String join(byte[] array) {
        Object[] bytes = new Byte[array.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = new Byte(array[i]);
        }
        return Strings.join(bytes, null);
    }

    public static String join(StringBuffer buff, Object[] array, String prefix, String separator, String suffix) {
        buff.append(prefix);
        Strings.join(buff, array, separator);
        buff.append(suffix);
        return buff.toString();
    }

    public static String join(Object[] array, String prefix, String separator, String suffix) {
        return Strings.join(new StringBuffer(), array, prefix, separator, suffix);
    }

    public static int count(String string2, String substring) {
        int count2 = 0;
        int idx = 0;
        while ((idx = string2.indexOf(substring, idx)) != -1) {
            ++idx;
            ++count2;
        }
        return count2;
    }

    public static int count(String string2, char c) {
        return Strings.count(string2, String.valueOf(c));
    }

    public static String pad(StringBuffer buff, String string2, int count2) {
        for (int i = 0; i < count2; ++i) {
            buff.append(string2);
        }
        return buff.toString();
    }

    public static String pad(String string2, int count2) {
        return Strings.pad(new StringBuffer(), string2, count2);
    }

    public static String pad(Object obj, int count2) {
        return Strings.pad(new StringBuffer(), String.valueOf(obj), count2);
    }

    public static boolean compare(String me, String you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static boolean isEmpty(String string2) {
        return string2.equals(EMPTY);
    }

    public static int nthIndexOf(String string2, String token, int index) {
        int j = 0;
        for (int i = 0; i < index && (j = string2.indexOf(token, j + 1)) != -1; ++i) {
        }
        return j;
    }

    public static String capitalize(String string2) {
        if (string2 == null) {
            throw new NullArgumentException("string");
        }
        if (string2.equals(EMPTY)) {
            throw new EmptyStringException("string");
        }
        return Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
    }

    public static String[] trim(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    public static URL toURL(String urlspec, String relativePrefix) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                url = Strings.makeURLFromFilespec(url.getFile(), relativePrefix);
            }
        }
        catch (Exception e) {
            try {
                url = Strings.makeURLFromFilespec(urlspec, relativePrefix);
            }
            catch (IOException n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    public static URI toURI(String urispec, String relativePrefix) throws URISyntaxException {
        URI uri = (urispec = urispec.trim()).startsWith("file:") ? Strings.makeURIFromFilespec(urispec.substring(5), relativePrefix) : new URI(urispec);
        return uri;
    }

    private static URL makeURLFromFilespec(String filespec, String relativePrefix) throws IOException {
        File file = new File(Strings.decode(filespec));
        if (relativePrefix != null && !file.isAbsolute()) {
            file = new File(relativePrefix, filespec);
        }
        file = file.getCanonicalFile();
        return file.toURI().toURL();
    }

    private static String decode(String filespec) {
        try {
            return URLDecoder.decode(filespec, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error decoding filespec: " + filespec, e);
        }
    }

    private static URI makeURIFromFilespec(String filespec, String relativePrefix) {
        File file = new File(Strings.decode(filespec));
        if (relativePrefix != null && !file.isAbsolute()) {
            file = new File(relativePrefix, filespec);
        }
        return file.toURI();
    }

    public static URL toURL(String urlspec) throws MalformedURLException {
        return Strings.toURL(urlspec, null);
    }

    public static URI toURI(String urispec) throws URISyntaxException {
        return Strings.toURI(urispec, null);
    }

    public static final boolean isJavaKeyword(String s2) {
        if (s2 == null || s2.length() == 0) {
            return false;
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(s2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isEjbQlIdentifier(String s2) {
        if (s2 == null || s2.length() == 0) {
            return false;
        }
        for (int i = 0; i < ejbQlIdentifiers.length; ++i) {
            if (!ejbQlIdentifiers[i].equalsIgnoreCase(s2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isValidJavaIdentifier(String s2) {
        if (s2 == null || s2.length() == 0) {
            return false;
        }
        char[] c = s2.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public static String removeWhiteSpace(String s2) {
        String retn = null;
        if (s2 != null) {
            int len = s2.length();
            StringBuffer sbuf = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = s2.charAt(i);
                if (Character.isWhitespace(c)) continue;
                sbuf.append(c);
            }
            retn = sbuf.toString();
        }
        return retn;
    }

    public static final String defaultToString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public static final void defaultToString(JBossStringBuilder buffer, Object object) {
        if (object == null) {
            buffer.append("null");
        } else {
            buffer.append(object.getClass().getName());
            buffer.append('@');
            buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    public static final void defaultToString(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("null");
        } else {
            buffer.append(object.getClass().getName());
            buffer.append('@');
            buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    public static long parseTimePeriod(String period) {
        try {
            long factor;
            String s2 = period.toLowerCase();
            if (s2.endsWith("msec")) {
                s2 = s2.substring(0, s2.lastIndexOf("msec"));
                factor = 1L;
            } else if (s2.endsWith("sec")) {
                s2 = s2.substring(0, s2.lastIndexOf("sec"));
                factor = 1000L;
            } else if (s2.endsWith("min")) {
                s2 = s2.substring(0, s2.lastIndexOf("min"));
                factor = 60000L;
            } else if (s2.endsWith("h")) {
                s2 = s2.substring(0, s2.lastIndexOf("h"));
                factor = 3600000L;
            } else {
                factor = 1L;
            }
            return Long.parseLong(s2) * factor;
        }
        catch (RuntimeException e) {
            throw new NumberFormatException("For input time period: '" + period + "'");
        }
    }

    public static long parsePositiveTimePeriod(String period) {
        long retval = Strings.parseTimePeriod(period);
        if (retval < 0L) {
            throw new NumberFormatException("Negative input time period: '" + period + "'");
        }
        return retval;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String trimLeadingWhitespace(String str) {
        return Strings.trimLeadingCharacter(str, CharacterChecker.WHITESPACE);
    }

    public static String trimLeadingCharacter(String str, final char leadingCharacter) {
        return Strings.trimLeadingCharacter(str, new CharacterChecker(){

            @Override
            public boolean isCharacterLegal(char character) {
                return character == leadingCharacter;
            }
        });
    }

    public static String trimLeadingCharacter(String str, CharacterChecker checker) {
        if (!Strings.hasLength(str)) {
            return str;
        }
        if (checker == null) {
            throw new IllegalArgumentException("Null character checker");
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && checker.isCharacterLegal(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static boolean hasLength(String string2) {
        return string2 != null && string2.length() > 0;
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = Strings.tokenizeToStringArray(localeString, "_ ", false, false);
        String language2 = parts.length > 0 ? parts[0] : EMPTY;
        String country = parts.length > 1 ? parts[1] : EMPTY;
        String variant = EMPTY;
        if (parts.length >= 2 && (variant = Strings.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country) + country.length()))).startsWith("_")) {
            variant = Strings.trimLeadingCharacter(variant, '_');
        }
        return language2.length() > 0 ? new Locale(language2, country, variant) : null;
    }

    public static class Range {
        public int begin;
        public int end;

        public Range(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public Range() {
        }
    }
}

