/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.Serializable;

public class LongCounter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1615297462859270139L;
    private long count;

    public LongCounter(long count2) {
        this.count = count2;
    }

    public LongCounter() {
    }

    public long increment() {
        return ++this.count;
    }

    public long decrement() {
        return --this.count;
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0L;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((LongCounter)obj).count == this.count;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.count);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static LongCounter makeSynchronized(LongCounter counter) {
        return new Wrapper(counter){
            private static final long serialVersionUID = 8903330696503363758L;

            @Override
            public synchronized long increment() {
                return this.counter.increment();
            }

            @Override
            public synchronized long decrement() {
                return this.counter.decrement();
            }

            @Override
            public synchronized long getCount() {
                return this.counter.getCount();
            }

            @Override
            public synchronized void reset() {
                this.counter.reset();
            }

            public synchronized int hashCode() {
                return this.counter.hashCode();
            }

            @Override
            public synchronized boolean equals(Object obj) {
                return this.counter.equals(obj);
            }

            @Override
            public synchronized String toString() {
                return this.counter.toString();
            }

            @Override
            public synchronized Object clone() {
                return this.counter.clone();
            }
        };
    }

    public static LongCounter makeDirectional(LongCounter counter, boolean increasing) {
        Wrapper temp = increasing ? new Wrapper(counter){
            private static final long serialVersionUID = -8902748795144754375L;

            @Override
            public long decrement() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void reset() {
                throw new UnsupportedOperationException();
            }
        } : new Wrapper(counter){
            private static final long serialVersionUID = 2584758778978644599L;

            @Override
            public long increment() {
                throw new UnsupportedOperationException();
            }
        };
        return temp;
    }

    private static class Wrapper
    extends LongCounter {
        private static final long serialVersionUID = 6720507617603163762L;
        protected final LongCounter counter;

        public Wrapper(LongCounter counter) {
            this.counter = counter;
        }

        @Override
        public long increment() {
            return this.counter.increment();
        }

        @Override
        public long decrement() {
            return this.counter.decrement();
        }

        @Override
        public long getCount() {
            return this.counter.getCount();
        }

        @Override
        public void reset() {
            this.counter.reset();
        }

        @Override
        public boolean equals(Object obj) {
            return this.counter.equals(obj);
        }

        @Override
        public String toString() {
            return this.counter.toString();
        }

        @Override
        public Object clone() {
            return this.counter.clone();
        }
    }
}

