/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.Serializable;
import java.util.Arrays;

public class JBossStringBuilder
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 1874946609763446794L;
    protected char[] chars;
    protected int pos;

    public JBossStringBuilder() {
        this(16);
    }

    public JBossStringBuilder(int capacity) {
        this.chars = new char[capacity];
    }

    public JBossStringBuilder(String string2) {
        this(string2.length() + 16);
        this.append(string2);
    }

    public JBossStringBuilder(CharSequence charSequence) {
        this(charSequence.length() + 16);
        this.append(charSequence);
    }

    public JBossStringBuilder(char[] ch) {
        this(ch, 0, ch.length);
    }

    public JBossStringBuilder(char[] ch, int start, int length2) {
        this(length2 + 16);
        this.append(ch, start, length2);
    }

    public JBossStringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public JBossStringBuilder append(String string2) {
        int length2;
        if (string2 == null) {
            string2 = "null";
        }
        if ((length2 = string2.length()) == 0) {
            return this;
        }
        int afterAppend = this.pos + length2;
        if (afterAppend > this.chars.length) {
            this.expandCapacity(afterAppend);
        }
        string2.getChars(0, length2, this.chars, this.pos);
        this.pos = afterAppend;
        return this;
    }

    public JBossStringBuilder append(StringBuffer buffer) {
        if (buffer == null) {
            return this.append("null");
        }
        int length2 = buffer.length();
        if (length2 == 0) {
            return this;
        }
        int afterAppend = this.pos + length2;
        if (afterAppend > this.chars.length) {
            this.expandCapacity(afterAppend);
        }
        buffer.getChars(0, length2, this.chars, this.pos);
        this.pos = afterAppend;
        return this;
    }

    public JBossStringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.append("null");
        }
        int length2 = charSequence.length();
        if (length2 == 0) {
            return this;
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public JBossStringBuilder append(CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            return this.append("null");
        }
        if (start < 0 || end < 0 || start > end || start > charSequence.length()) {
            throw new IndexOutOfBoundsException("Invalid start=" + start + " end=" + end + " length=" + charSequence.length());
        }
        int length2 = end - start;
        if (length2 == 0) {
            return this;
        }
        int afterAppend = this.pos + length2;
        if (afterAppend > this.chars.length) {
            this.expandCapacity(afterAppend);
        }
        for (int i = start; i < end; ++i) {
            this.chars[this.pos++] = charSequence.charAt(i);
        }
        this.pos = afterAppend;
        return this;
    }

    public JBossStringBuilder append(char[] array) {
        if (array == null) {
            return this.append("null");
        }
        if (array.length == 0) {
            return this;
        }
        String string2 = String.valueOf(array);
        return this.append(string2);
    }

    public JBossStringBuilder append(char[] array, int offset, int length2) {
        if (array == null) {
            return this.append("null");
        }
        int arrayLength = array.length;
        if (offset < 0 || length2 < 0 || offset + length2 > arrayLength) {
            throw new IndexOutOfBoundsException("Invalid offset=" + offset + " length=" + length2 + " array.length=" + arrayLength);
        }
        if (length2 == 0 || arrayLength == 0) {
            return this;
        }
        String string2 = String.valueOf(array, offset, length2);
        return this.append(string2);
    }

    public JBossStringBuilder append(boolean primitive) {
        String string2 = String.valueOf(primitive);
        return this.append(string2);
    }

    public JBossStringBuilder append(char primitive) {
        String string2 = String.valueOf(primitive);
        return this.append(string2);
    }

    public JBossStringBuilder append(int primitive) {
        String string2 = String.valueOf(primitive);
        return this.append(string2);
    }

    public JBossStringBuilder append(long primitive) {
        String string2 = String.valueOf(primitive);
        return this.append(string2);
    }

    public JBossStringBuilder append(float primitive) {
        String string2 = String.valueOf(primitive);
        return this.append(string2);
    }

    public JBossStringBuilder append(double primitive) {
        String string2 = String.valueOf(primitive);
        return this.append(string2);
    }

    public JBossStringBuilder delete(int start, int end) {
        if (start < 0 || start > this.pos || start > end || end > this.pos) {
            throw new IndexOutOfBoundsException("Invalid start=" + start + " end=" + end + " length=" + this.pos);
        }
        if (start == end) {
            return this;
        }
        int removed = end - start;
        System.arraycopy(this.chars, start + removed, this.chars, start, this.pos - end);
        this.pos -= removed;
        return this;
    }

    public JBossStringBuilder deleteCharAt(int index) {
        return this.delete(index, 1);
    }

    public JBossStringBuilder replace(int start, int end, String string2) {
        this.delete(start, end);
        return this.insert(start, string2);
    }

    public JBossStringBuilder insert(int index, char[] string2) {
        return this.insert(index, string2, 0, string2.length);
    }

    public JBossStringBuilder insert(int index, char[] string2, int offset, int len) {
        int stringLength = string2.length;
        if (index < 0 || index > this.pos || offset < 0 || len < 0 || offset + len > string2.length) {
            throw new IndexOutOfBoundsException("Invalid index=" + index + " offset=" + offset + " len=" + len + " string.length=" + stringLength + " length=" + this.pos);
        }
        if (len == 0) {
            return this;
        }
        int afterAppend = this.pos + len;
        if (afterAppend > this.chars.length) {
            this.expandCapacity(afterAppend);
        }
        System.arraycopy(this.chars, index, this.chars, index + stringLength, this.pos - index);
        System.arraycopy(string2, offset, this.chars, index, len);
        this.pos = afterAppend;
        return this;
    }

    public JBossStringBuilder insert(int offset, Object object) {
        if (object == null) {
            return this.insert(offset, "null");
        }
        return this.insert(offset, String.valueOf(object));
    }

    public JBossStringBuilder insert(int offset, String string2) {
        int stringLength;
        int afterAppend;
        if (offset < 0 || offset > this.pos) {
            throw new IndexOutOfBoundsException("Invalid offset=" + offset + " length=" + this.pos);
        }
        if (string2 == null) {
            string2 = "null";
        }
        if ((afterAppend = this.pos + (stringLength = string2.length())) > this.chars.length) {
            this.expandCapacity(afterAppend);
        }
        System.arraycopy(this.chars, offset, this.chars, offset + stringLength, this.pos - offset);
        string2.getChars(0, stringLength, this.chars, offset);
        this.pos = afterAppend;
        return this;
    }

    public JBossStringBuilder insert(int offset, CharSequence charSequence) {
        if (charSequence == null) {
            return this.insert(offset, "null");
        }
        return this.insert(offset, charSequence, 0, charSequence.length());
    }

    public JBossStringBuilder insert(int offset, CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            charSequence = "null";
        }
        int sequenceLength = charSequence.length();
        if (offset < 0 || offset > this.pos || start < 0 || end < 0 || start > sequenceLength || end > sequenceLength || start > end) {
            throw new IndexOutOfBoundsException("Invalid offset=" + offset + " start=" + start + " end=" + end + " sequence.length()=" + sequenceLength + " length=" + this.pos);
        }
        int len = end - start;
        if (len == 0) {
            return this;
        }
        int afterAppend = this.pos + len;
        if (afterAppend > this.chars.length) {
            this.expandCapacity(afterAppend);
        }
        System.arraycopy(this.chars, offset, this.chars, offset + sequenceLength, this.pos - offset);
        for (int i = start; i < end; ++i) {
            this.chars[offset++] = charSequence.charAt(i);
        }
        this.pos = afterAppend;
        return this;
    }

    public JBossStringBuilder insert(int offset, boolean primitive) {
        return this.insert(offset, String.valueOf(primitive));
    }

    public JBossStringBuilder insert(int offset, char primitive) {
        return this.insert(offset, String.valueOf(primitive));
    }

    public JBossStringBuilder insert(int offset, int primitive) {
        return this.insert(offset, String.valueOf(primitive));
    }

    public JBossStringBuilder insert(int offset, long primitive) {
        return this.insert(offset, String.valueOf(primitive));
    }

    public JBossStringBuilder insert(int offset, float primitive) {
        return this.insert(offset, String.valueOf(primitive));
    }

    public JBossStringBuilder insert(int offset, double primitive) {
        return this.insert(offset, String.valueOf(primitive));
    }

    public int indexOf(String string2) {
        return this.indexOf(string2, 0);
    }

    public int indexOf(String string2, int fromIndex) {
        return this.toString().indexOf(string2, fromIndex);
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(char ch, int fromIndex) {
        return this.toString().indexOf(ch, fromIndex);
    }

    public int lastIndexOf(String string2) {
        return this.lastIndexOf(string2, this.pos);
    }

    public int lastIndexOf(String string2, int fromIndex) {
        return this.toString().lastIndexOf(string2, fromIndex);
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.pos);
    }

    public int lastIndexOf(char ch, int fromIndex) {
        return this.toString().lastIndexOf(ch, fromIndex);
    }

    public JBossStringBuilder reverse() {
        char[] tmp = new char[this.pos];
        for (int n = 0; n < this.pos; ++n) {
            tmp[n] = this.chars[this.pos - n - 1];
        }
        this.chars = tmp;
        return this;
    }

    @Override
    public String toString() {
        return new String(this.chars, 0, this.pos);
    }

    @Override
    public int length() {
        return this.pos;
    }

    public int capacity() {
        return this.chars.length;
    }

    public void ensureCapacity(int minimum) {
        if (minimum < 0 || minimum < this.chars.length) {
            return;
        }
        this.expandCapacity(minimum);
    }

    public void trimToSize() {
        char[] trimmed = new char[this.pos];
        System.arraycopy(this.chars, 0, trimmed, 0, this.pos);
        this.chars = trimmed;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.chars.length) {
            this.expandCapacity(newLength);
        }
        Arrays.fill(this.chars, newLength, this.chars.length, '\u0000');
        this.pos = newLength;
    }

    @Override
    public char charAt(int index) {
        return this.chars[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || dstBegin < 0 || srcBegin > srcEnd || srcEnd > this.pos || dstBegin + srcEnd - srcBegin > dst.length) {
            throw new IndexOutOfBoundsException("Invalid srcBegin=" + srcBegin + " srcEnd=" + srcEnd + " dstBegin=" + dstBegin + " dst.length=" + dst.length + " length=" + this.pos);
        }
        int len = srcEnd - srcBegin;
        if (len == 0) {
            return;
        }
        System.arraycopy(this.chars, srcBegin, dst, dstBegin, len);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index > this.pos) {
            throw new IndexOutOfBoundsException("Invalid index=" + index + " length=" + this.pos);
        }
        this.chars[index] = ch;
    }

    public String substring(int start) {
        return this.substring(start, this.pos);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start, int end) {
        if (start < 0 || end < 0 || start > end || end > this.pos) {
            throw new IndexOutOfBoundsException("Invalid start=" + start + " end=" + end + " length=" + this.pos);
        }
        return new String(this.chars, start, end - start);
    }

    protected void expandCapacity(int minimum) {
        int newSize = this.chars.length * 2;
        if (minimum > newSize) {
            newSize = minimum;
        }
        char[] newChars = new char[newSize];
        System.arraycopy(this.chars, 0, newChars, 0, this.pos);
        this.chars = newChars;
    }
}

