/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.sockets;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class MethodHash {
    static Map hashMap = new WeakHashMap();

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = intf.getMethods();
        HashMap<String, Long> map2 = new HashMap<String, Long>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodDesc = method.getName() + "(";
            for (int j = 0; j < parameterTypes.length; ++j) {
                methodDesc = methodDesc + MethodHash.getTypeString(parameterTypes[j]);
            }
            methodDesc = methodDesc + ")" + MethodHash.getTypeString(method.getReturnType());
            try {
                long hash = 0L;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
                MessageDigest messagedigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
                dataoutputstream.writeUTF(methodDesc);
                dataoutputstream.flush();
                byte[] abyte0 = messagedigest.digest();
                for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                    hash += (long)(abyte0[j] & 0xFF) << j * 8;
                }
                map2.put(method.toString(), new Long(hash));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map2;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MethodHash.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    public static long calculateHash(Method method) {
        Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
        if (methodHashes == null) {
            methodHashes = MethodHash.getInterfaceHashes(method.getDeclaringClass());
            WeakHashMap newHashMap = new WeakHashMap();
            newHashMap.putAll(hashMap);
            newHashMap.put(method.getDeclaringClass(), methodHashes);
            hashMap = newHashMap;
        }
        return (Long)methodHashes.get(method.toString());
    }
}

