/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.trait;

import java.util.List;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.trait.TraitHelpersTuple;
import org.codehaus.groovy.transform.trait.Traits;

class SuperCallTraitTransformer
extends ClassCodeExpressionTransformer {
    private final SourceUnit unit;

    SuperCallTraitTransformer(SourceUnit unit) {
        this.unit = unit;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.unit;
    }

    @Override
    public Expression transform(Expression exp) {
        if (exp instanceof PropertyExpression) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        if (exp instanceof MethodCallExpression) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        return super.transform(exp);
    }

    private Expression transformMethodCallExpression(MethodCallExpression exp) {
        Expression objectExpression = this.transform(exp.getObjectExpression());
        ClassNode traitReceiver = (ClassNode)objectExpression.getNodeMetaData(SuperCallTraitTransformer.class);
        if (traitReceiver != null) {
            TraitHelpersTuple helpers = Traits.findHelpers(traitReceiver);
            ClassExpression receiver = new ClassExpression(helpers.getHelper());
            ArgumentListExpression newArgs = new ArgumentListExpression();
            Expression arguments2 = exp.getArguments();
            newArgs.addExpression(new VariableExpression("this"));
            if (arguments2 instanceof TupleExpression) {
                List<Expression> expressions = ((TupleExpression)arguments2).getExpressions();
                for (Expression expression : expressions) {
                    newArgs.addExpression(this.transform(expression));
                }
            } else {
                newArgs.addExpression(arguments2);
            }
            MethodCallExpression result2 = new MethodCallExpression((Expression)receiver, exp.getMethod(), (Expression)newArgs);
            result2.setImplicitThis(false);
            result2.setSpreadSafe(exp.isSpreadSafe());
            result2.setSafe(exp.isSafe());
            result2.setSourcePosition(exp);
            return result2;
        }
        return super.transform(exp);
    }

    private Expression transformPropertyExpression(PropertyExpression expression) {
        Expression objectExpression = expression.getObjectExpression();
        ClassNode type = objectExpression.getType();
        if (objectExpression instanceof ClassExpression && Traits.isTrait(type) && "super".equals(expression.getPropertyAsString())) {
            expression.putNodeMetaData(SuperCallTraitTransformer.class, type);
        }
        return super.transform(expression);
    }
}

