/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.classgen.asm.MopWriter;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class MethodCallExpressionTransformer {
    private final StaticCompilationTransformer staticCompilationTransformer;

    public MethodCallExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    Expression transformMethodCallExpression(MethodCallExpression expr) {
        FieldNode field2;
        ClassNode superCallReceiver = (ClassNode)expr.getNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED);
        if (superCallReceiver != null) {
            return this.transformMethodCallExpression(this.transformToMopSuperCall(superCallReceiver, expr));
        }
        Expression objectExpression = expr.getObjectExpression();
        ClassNode type = this.staticCompilationTransformer.getTypeChooser().resolveType(objectExpression, this.staticCompilationTransformer.getClassNode());
        if (this.isCallOnClosure(expr) && (field2 = this.staticCompilationTransformer.getClassNode().getField(expr.getMethodAsString())) != null) {
            VariableExpression vexp = new VariableExpression(field2);
            MethodCallExpression result2 = new MethodCallExpression((Expression)vexp, "call", this.staticCompilationTransformer.transform(expr.getArguments()));
            result2.setImplicitThis(false);
            result2.setSourcePosition(expr);
            result2.setSafe(expr.isSafe());
            result2.setSpreadSafe(expr.isSpreadSafe());
            result2.setMethodTarget(StaticTypeCheckingVisitor.CLOSURE_CALL_VARGS);
            return result2;
        }
        if (type != null && type.isArray()) {
            List<Expression> argList;
            Expression arguments2;
            String method = expr.getMethodAsString();
            ClassNode componentType = type.getComponentType();
            if ("getAt".equals(method)) {
                List<Expression> argList2;
                Expression arguments3 = expr.getArguments();
                if (arguments3 instanceof TupleExpression && (argList2 = ((TupleExpression)arguments3).getExpressions()).size() == 1) {
                    Expression indexExpr = argList2.get(0);
                    ClassNode argType = this.staticCompilationTransformer.getTypeChooser().resolveType(indexExpr, this.staticCompilationTransformer.getClassNode());
                    ClassNode indexType = ClassHelper.getWrapper(argType);
                    if (componentType.isEnum() && ClassHelper.Number_TYPE == indexType) {
                        indexType = ClassHelper.Integer_TYPE;
                    }
                    if (argType != null && ClassHelper.Integer_TYPE == indexType) {
                        BinaryExpression binaryExpression = new BinaryExpression(objectExpression, Token.newSymbol("[", indexExpr.getLineNumber(), indexExpr.getColumnNumber()), indexExpr);
                        binaryExpression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, componentType);
                        return this.staticCompilationTransformer.transform(binaryExpression);
                    }
                }
            } else if ("putAt".equals(method) && (arguments2 = expr.getArguments()) instanceof TupleExpression && (argList = ((TupleExpression)arguments2).getExpressions()).size() == 2) {
                Expression indexExpr = argList.get(0);
                Expression objExpr = argList.get(1);
                ClassNode argType = this.staticCompilationTransformer.getTypeChooser().resolveType(indexExpr, this.staticCompilationTransformer.getClassNode());
                if (argType != null && ClassHelper.Integer_TYPE == ClassHelper.getWrapper(argType)) {
                    BinaryExpression arrayGet = new BinaryExpression(objectExpression, Token.newSymbol("[", indexExpr.getLineNumber(), indexExpr.getColumnNumber()), indexExpr);
                    arrayGet.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, componentType);
                    BinaryExpression assignment = new BinaryExpression(arrayGet, Token.newSymbol("=", objExpr.getLineNumber(), objExpr.getColumnNumber()), objExpr);
                    return this.staticCompilationTransformer.transform(assignment);
                }
            }
        }
        return this.staticCompilationTransformer.superTransform(expr);
    }

    private MethodCallExpression transformToMopSuperCall(ClassNode superCallReceiver, MethodCallExpression expr) {
        MethodNode mn = (MethodNode)expr.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        String mopName = MopWriter.getMopMethodName(mn, false);
        MethodNode direct = new MethodNode(mopName, 4097, mn.getReturnType(), mn.getParameters(), mn.getExceptions(), EmptyStatement.INSTANCE);
        direct.setDeclaringClass(superCallReceiver);
        MethodCallExpression result2 = new MethodCallExpression((Expression)new VariableExpression("this"), mopName, expr.getArguments());
        result2.setImplicitThis(true);
        result2.setSpreadSafe(false);
        result2.setSafe(false);
        result2.setSourcePosition(expr);
        result2.setMethodTarget(direct);
        return result2;
    }

    private boolean isCallOnClosure(MethodCallExpression expr) {
        return expr.isImplicitThis() && expr.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET) == StaticTypeCheckingVisitor.CLOSURE_CALL_VARGS && !"call".equals(expr.getMethodAsString());
    }
}

