/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.InsnOperand;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class CPOperand
extends InsnOperand {
    CP cpe;
    boolean wide;

    int size(ClassEnv ce, CodeAttr code) {
        if (this.wide) {
            return 2;
        }
        return 1;
    }

    CPOperand(CP cpe) {
        this.cpe = cpe;
        this.wide = true;
    }

    CPOperand(CP cpe, boolean wide) {
        this.cpe = cpe;
        this.wide = wide;
    }

    void resolve(ClassEnv e) {
        e.addCPItem(this.cpe);
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        int idx = e.getCPIndex(this.cpe);
        if (this.wide) {
            out.writeShort((short)idx);
        } else {
            if (idx > 255) {
                throw new jasError("exceeded size for small cpidx" + this.cpe);
            }
            out.writeByte((byte)(0xFF & idx));
        }
    }
}

