/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.collect.Lists;
import heros.fieldsens.FlowFunction;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import java.util.List;

public abstract class Resolver<Field, Fact, Stmt, Method> {
    private boolean interest = false;
    private List<InterestCallback<Field, Fact, Stmt, Method>> interestCallbacks = Lists.newLinkedList();
    protected PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer;
    private boolean canBeResolvedEmpty = false;

    public Resolver(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer) {
        this.analyzer = analyzer;
    }

    public abstract void resolve(FlowFunction.Constraint<Field> var1, InterestCallback<Field, Fact, Stmt, Method> var2);

    public void interest() {
        if (this.interest) {
            return;
        }
        this.log("Interest given");
        this.interest = true;
        for (InterestCallback interestCallback : Lists.newLinkedList(this.interestCallbacks)) {
            interestCallback.interest(this.analyzer, this);
        }
        if (this.canBeResolvedEmpty) {
            this.interestCallbacks = null;
        }
    }

    protected void canBeResolvedEmpty() {
        if (this.canBeResolvedEmpty) {
            return;
        }
        this.canBeResolvedEmpty = true;
        for (InterestCallback interestCallback : Lists.newLinkedList(this.interestCallbacks)) {
            interestCallback.canBeResolvedEmpty();
        }
        if (this.interest) {
            this.interestCallbacks = null;
        }
    }

    public boolean isInterestGiven() {
        return this.interest;
    }

    protected void registerCallback(InterestCallback<Field, Fact, Stmt, Method> callback) {
        if (this.interest) {
            callback.interest(this.analyzer, this);
        } else {
            this.log("Callback registered");
            this.interestCallbacks.add(callback);
        }
        if (this.canBeResolvedEmpty) {
            callback.canBeResolvedEmpty();
        }
    }

    protected abstract void log(String var1);
}

