/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import heros.fieldsens.AccessPath;
import heros.fieldsens.AccessPathHandler;
import heros.fieldsens.structs.WrappedFact;
import java.util.Set;

public interface FlowFunction<FieldRef, D, Stmt, Method> {
    public Set<ConstrainedFact<FieldRef, D, Stmt, Method>> computeTargets(D var1, AccessPathHandler<FieldRef, D, Stmt, Method> var2);

    public static class ReadFieldConstraint<FieldRef>
    implements Constraint<FieldRef> {
        private FieldRef fieldRef;

        public ReadFieldConstraint(FieldRef fieldRef) {
            this.fieldRef = fieldRef;
        }

        @Override
        public AccessPath<FieldRef> applyToAccessPath(AccessPath<FieldRef> accPath) {
            return accPath.append(this.fieldRef);
        }

        public String toString() {
            return this.fieldRef.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.fieldRef == null ? 0 : this.fieldRef.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReadFieldConstraint)) {
                return false;
            }
            ReadFieldConstraint other = (ReadFieldConstraint)obj;
            return !(this.fieldRef == null ? other.fieldRef != null : !this.fieldRef.equals(other.fieldRef));
        }

        @Override
        public boolean canBeAppliedTo(AccessPath<FieldRef> accPath) {
            return !accPath.isAccessInExclusions(this.fieldRef);
        }
    }

    public static class WriteFieldConstraint<FieldRef>
    implements Constraint<FieldRef> {
        private FieldRef fieldRef;

        public WriteFieldConstraint(FieldRef fieldRef) {
            this.fieldRef = fieldRef;
        }

        @Override
        public AccessPath<FieldRef> applyToAccessPath(AccessPath<FieldRef> accPath) {
            return accPath.appendExcludedFieldReference(this.fieldRef);
        }

        public String toString() {
            return "^" + this.fieldRef.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.fieldRef == null ? 0 : this.fieldRef.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WriteFieldConstraint)) {
                return false;
            }
            WriteFieldConstraint other = (WriteFieldConstraint)obj;
            return !(this.fieldRef == null ? other.fieldRef != null : !this.fieldRef.equals(other.fieldRef));
        }

        @Override
        public boolean canBeAppliedTo(AccessPath<FieldRef> accPath) {
            return true;
        }
    }

    public static interface Constraint<FieldRef> {
        public AccessPath<FieldRef> applyToAccessPath(AccessPath<FieldRef> var1);

        public boolean canBeAppliedTo(AccessPath<FieldRef> var1);
    }

    public static class ConstrainedFact<FieldRef, D, Stmt, Method> {
        private WrappedFact<FieldRef, D, Stmt, Method> fact;
        private Constraint<FieldRef> constraint;

        ConstrainedFact(WrappedFact<FieldRef, D, Stmt, Method> fact) {
            this.fact = fact;
            this.constraint = null;
        }

        ConstrainedFact(WrappedFact<FieldRef, D, Stmt, Method> fact, Constraint<FieldRef> constraint) {
            this.fact = fact;
            this.constraint = constraint;
        }

        public WrappedFact<FieldRef, D, Stmt, Method> getFact() {
            return this.fact;
        }

        public Constraint<FieldRef> getConstraint() {
            return this.constraint;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.constraint == null ? 0 : this.constraint.hashCode());
            result2 = 31 * result2 + (this.fact == null ? 0 : this.fact.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ConstrainedFact)) {
                return false;
            }
            ConstrainedFact other = (ConstrainedFact)obj;
            if (this.constraint == null ? other.constraint != null : !this.constraint.equals(other.constraint)) {
                return false;
            }
            return !(this.fact == null ? other.fact != null : !this.fact.equals(other.fact));
        }

        public String toString() {
            return this.fact.toString() + "<" + this.constraint + ">";
        }
    }
}

