/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.BuilderASTTransformation;

public class DefaultStrategy
extends BuilderASTTransformation.AbstractBuilderStrategy {
    private static final Expression DEFAULT_INITIAL_VALUE = null;

    @Override
    public void build(BuilderASTTransformation transform2, AnnotatedNode annotatedNode, AnnotationNode anno) {
        if (annotatedNode instanceof ClassNode) {
            this.buildClass(transform2, (ClassNode)annotatedNode, anno);
        } else if (annotatedNode instanceof MethodNode) {
            this.buildMethod(transform2, (MethodNode)annotatedNode, anno);
        }
    }

    public void buildMethod(BuilderASTTransformation transform2, MethodNode mNode, AnnotationNode anno) {
        if (transform2.getMemberValue(anno, "includes") != null || transform2.getMemberValue(anno, "includes") != null) {
            transform2.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: includes/excludes only allowed on classes", anno);
        }
        String prefix = BuilderASTTransformation.getMemberStringValue(anno, "prefix", "");
        if (this.unsupportedAttribute(transform2, anno, "forClass")) {
            return;
        }
        int visibility = 4105;
        ClassNode buildee = mNode.getDeclaringClass();
        String builderClassName = BuilderASTTransformation.getMemberStringValue(anno, "builderClassName", buildee.getName() + "Builder");
        String fullName = buildee.getName() + "$" + builderClassName;
        InnerClassNode builder = new InnerClassNode(buildee, fullName, 4105, ClassHelper.OBJECT_TYPE);
        buildee.getModule().addClass(builder);
        buildee.addMethod(DefaultStrategy.createBuilderMethod(transform2, anno, builder));
        for (Parameter parameter : mNode.getParameters()) {
            builder.addField(DefaultStrategy.createFieldCopy(buildee, parameter));
            builder.addMethod(this.createBuilderMethodForProp(builder, new BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo(parameter.getName(), parameter.getType()), prefix));
        }
        builder.addMethod(this.createBuildMethodForMethod(transform2, anno, buildee, mNode, mNode.getParameters()));
    }

    public void buildClass(BuilderASTTransformation transform2, ClassNode buildee, AnnotationNode anno) {
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes = new ArrayList<String>();
        if (!this.getIncludeExclude(transform2, anno, buildee, excludes, includes)) {
            return;
        }
        String prefix = BuilderASTTransformation.getMemberStringValue(anno, "prefix", "");
        if (this.unsupportedAttribute(transform2, anno, "forClass")) {
            return;
        }
        int visibility = 9;
        String builderClassName = BuilderASTTransformation.getMemberStringValue(anno, "builderClassName", buildee.getName() + "Builder");
        String fullName = buildee.getName() + "$" + builderClassName;
        InnerClassNode builder = new InnerClassNode(buildee, fullName, 9, ClassHelper.OBJECT_TYPE);
        buildee.getModule().addClass(builder);
        buildee.addMethod(DefaultStrategy.createBuilderMethod(transform2, anno, builder));
        List<FieldNode> fields = GeneralUtils.getInstancePropertyFields(buildee);
        List<FieldNode> filteredFields = DefaultStrategy.selectFieldsFromExistingClass(fields, includes, excludes);
        for (FieldNode fieldNode : filteredFields) {
            Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(fieldNode.getDeclaringClass());
            GenericsUtils.extractSuperClassGenerics(fieldNode.getType(), buildee, genericsSpec);
            ClassNode correctedType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, fieldNode.getType());
            String fieldName = fieldNode.getName();
            builder.addField(DefaultStrategy.createFieldCopy(buildee, fieldName, correctedType));
            builder.addMethod(this.createBuilderMethodForProp(builder, new BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo(fieldName, correctedType), prefix));
        }
        builder.addMethod(DefaultStrategy.createBuildMethod(transform2, anno, buildee, filteredFields));
    }

    private MethodNode createBuildMethodForMethod(BuilderASTTransformation transform2, AnnotationNode anno, ClassNode buildee, MethodNode mNode, Parameter[] params) {
        ClassNode returnType;
        String buildMethodName = BuilderASTTransformation.getMemberStringValue(anno, "buildMethodName", "build");
        BlockStatement body = new BlockStatement();
        if (mNode instanceof ConstructorNode) {
            returnType = GenericsUtils.newClass(buildee);
            body.addStatement(GeneralUtils.returnS(GeneralUtils.ctorX(GenericsUtils.newClass(mNode.getDeclaringClass()), GeneralUtils.args(params))));
        } else {
            body.addStatement(GeneralUtils.returnS(GeneralUtils.callX(GenericsUtils.newClass(mNode.getDeclaringClass()), mNode.getName(), (Expression)GeneralUtils.args(params))));
            returnType = GenericsUtils.newClass(mNode.getReturnType());
        }
        return new MethodNode(buildMethodName, 1, returnType, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private static MethodNode createBuilderMethod(BuilderASTTransformation transform2, AnnotationNode anno, ClassNode builder) {
        String builderMethodName = BuilderASTTransformation.getMemberStringValue(anno, "builderMethodName", "builder");
        BlockStatement body = new BlockStatement();
        body.addStatement(GeneralUtils.returnS(GeneralUtils.ctorX(builder)));
        int visibility = 4105;
        return new MethodNode(builderMethodName, 4105, builder, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private static MethodNode createBuildMethod(BuilderASTTransformation transform2, AnnotationNode anno, ClassNode buildee, List<FieldNode> fields) {
        String buildMethodName = BuilderASTTransformation.getMemberStringValue(anno, "buildMethodName", "build");
        BlockStatement body = new BlockStatement();
        body.addStatement(GeneralUtils.returnS(DefaultStrategy.initializeInstance(buildee, fields, body)));
        return new MethodNode(buildMethodName, 1, GenericsUtils.newClass(buildee), BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private MethodNode createBuilderMethodForProp(ClassNode builder, BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo pinfo, String prefix) {
        String fieldName = pinfo.getName();
        String setterName = this.getSetterName(prefix, fieldName);
        return new MethodNode(setterName, 1, GenericsUtils.newClass(builder), GeneralUtils.params(GeneralUtils.param(pinfo.getType(), fieldName)), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(fieldName)), GeneralUtils.varX(fieldName, pinfo.getType()))), GeneralUtils.returnS(GeneralUtils.varX("this", builder))));
    }

    private static FieldNode createFieldCopy(ClassNode buildee, Parameter param2) {
        Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(buildee);
        GenericsUtils.extractSuperClassGenerics(param2.getType(), buildee, genericsSpec);
        ClassNode correctedParamType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, param2.getType());
        return new FieldNode(param2.getName(), 2, correctedParamType, buildee, param2.getInitialExpression());
    }

    private static FieldNode createFieldCopy(ClassNode buildee, String fieldName, ClassNode fieldType) {
        return new FieldNode(fieldName, 2, fieldType, buildee, DEFAULT_INITIAL_VALUE);
    }

    private static List<FieldNode> selectFieldsFromExistingClass(List<FieldNode> fieldNodes, List<String> includes, List<String> excludes) {
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        for (FieldNode fNode : fieldNodes) {
            if (AbstractASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
            fields.add(fNode);
        }
        return fields;
    }

    private static Expression initializeInstance(ClassNode buildee, List<FieldNode> fields, BlockStatement body) {
        VariableExpression instance = GeneralUtils.varX("_the" + buildee.getNameWithoutPackage(), buildee);
        body.addStatement(GeneralUtils.declS(instance, GeneralUtils.ctorX(buildee)));
        for (FieldNode field2 : fields) {
            body.addStatement(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)instance, field2.getName()), GeneralUtils.varX(field2))));
        }
        return instance;
    }
}

