/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Interceptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class TracingInterceptor
implements Interceptor {
    protected Writer writer = new PrintWriter(System.out);
    private int indent = 0;

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Object beforeInvoke(Object object, String methodName, Object[] arguments2) {
        this.write(object, methodName, arguments2, "before");
        ++this.indent;
        return null;
    }

    @Override
    public Object afterInvoke(Object object, String methodName, Object[] arguments2, Object result2) {
        --this.indent;
        this.write(object, methodName, arguments2, "after ");
        return result2;
    }

    @Override
    public boolean doInvoke() {
        return true;
    }

    private String indent() {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            result2.append("  ");
        }
        return result2.toString();
    }

    protected void write(Object object, String methodName, Object[] arguments2, String origin) {
        try {
            this.writer.write(this.indent());
            this.writer.write(origin);
            this.writer.write(" ");
            Class<?> theClass = object instanceof Class ? (Class<?>)object : object.getClass();
            this.writeInfo(theClass, methodName, arguments2);
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeInfo(Class aClass, String methodName, Object[] arguments2) throws IOException {
        this.writer.write(aClass.getName());
        this.writer.write(".");
        this.writer.write(methodName);
        this.writer.write("(");
        for (int i = 0; i < arguments2.length; ++i) {
            if (i > 0) {
                this.writer.write(", ");
            }
            Object argument = arguments2[i];
            this.writer.write(argument.getClass().getName());
        }
        this.writer.write(")");
    }
}

