/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import javax.annotation.Nullable;

abstract class AbstractRangeSet<C extends Comparable>
implements RangeSet<C> {
    AbstractRangeSet() {
    }

    @Override
    public boolean contains(C value2) {
        return this.rangeContaining(value2) != null;
    }

    @Override
    public Range<C> rangeContaining(C value2) {
        Preconditions.checkNotNull(value2);
        for (Range<C> range2 : this.asRanges()) {
            if (!range2.contains(value2)) continue;
            return range2;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.asRanges().isEmpty();
    }

    @Override
    public void add(Range<C> range2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Range<C> range2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.remove(Range.all());
    }

    @Override
    public boolean enclosesAll(RangeSet<C> other) {
        for (Range<C> range2 : other.asRanges()) {
            if (this.encloses(range2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addAll(RangeSet<C> other) {
        for (Range<C> range2 : other.asRanges()) {
            this.add(range2);
        }
    }

    @Override
    public void removeAll(RangeSet<C> other) {
        for (Range<C> range2 : other.asRanges()) {
            this.remove(range2);
        }
    }

    @Override
    public boolean encloses(Range<C> otherRange) {
        for (Range<C> range2 : this.asRanges()) {
            if (!range2.encloses(otherRange)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RangeSet) {
            RangeSet other = (RangeSet)obj;
            return this.asRanges().equals(other.asRanges());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.asRanges().hashCode();
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (Range range2 : this.asRanges()) {
            builder.append(range2);
        }
        builder.append('}');
        return builder.toString();
    }
}

