#!/usr/bin/python

"""
Module "asn" for Inguma based in the Scapy's implementation
Copyright (c) 2008 Hugo Teso <hugo.teso@gmail.com>

License is GPL
"""
import os
import sys
import time
import socket

import lib.scapy as scapy
from lib.libexploit import CIngumaModule

name = "asn"
brief_description = "ASN whois database query"
type = "discover"

class CAsnQuery(CIngumaModule):
    target = ""
    port = 0
    waitTime = 0
    timeout = 1
    exploitType = 1
    services = {}
    results = {}
    dict = None
    ret = False

    def help(self):
        print "target = <target host or coma separated list of hosts>"

    def run(self):
        if self.timeout < 5:
            self.timeout = 5

        ips = {}
        for x in self.target:
            ips[x] = None

        ASres = scapy.conf.AS_resolver
        ASN_query_list = dict.fromkeys(map(lambda x:x.rsplit(" ",1)[0],ips)).keys()
        ASNlist = ASres.resolve(*ASN_query_list)
        self.data = ASNlist

        return True

    def printSummary(self):
        print "ASN database information"
        print "------------------------"
        print
        for x in self.data:
            print str(x[0]) + "\t" + str(x[1]) + "\t" + x[2]
    	print
