/*
 * Decompiled with CFR 0.152.
 */
package httpscanner;

import httpscanner.httpsScannerEngine;

public class httpsScanner {
    static String HTTPS_SCANNER_VERSION = "httpsScanner Version 1.2";

    public static void main(String[] args) throws Exception {
        boolean connect;
        int x;
        if (args.length != 4) {
            System.err.println("\n\nUsage: java httpsScanner host port http_method url ");
            System.err.println("Example: java httpsScanner 127.0.0.1 443 HEAD /\n\n");
            httpsScanner.printAbout();
            System.exit(1);
        }
        String host = args[0];
        int port = new Integer(args[1]);
        String http_method = args[2];
        String url = args[3];
        int no_security = 0;
        int anonymous = 0;
        int weak = 0;
        int strong = 0;
        String[] nullCiphersuite = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
        String[] anonCiphersuite = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5"};
        String[] weakCiphersuite = new String[]{"SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA"};
        String[] strongCiphersuite = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"};
        String[] excellentCiphersuite = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA"};
        httpsScannerEngine s = new httpsScannerEngine();
        System.out.println("Scanning " + host + ":" + port);
        System.out.println("HTTP method: " + http_method);
        System.out.println("URL: " + url);
        System.out.println("\n\nhttpsScanner will now test your SSL web server with one ciphersuite at a time, starting with low security ciphersuites.");
        System.out.println("If a SSL connection can be established using the current ciphersuite, \"connection successful\" will be reported");
        System.out.println("If \"connection successful\" is reported for low security ciphersuites, you should disable these ciphersuites in your web server.");
        System.out.println("\n\nNo Security: Null cipher suites. These offer no encryption and should not be used.");
        for (x = 0; x < nullCiphersuite.length; ++x) {
            System.out.println("\n" + (x + 1) + ". Using " + nullCiphersuite[x]);
            connect = s.scan(host, port, http_method, url, nullCiphersuite[x]);
            if (connect) {
                System.out.println("Connection successful.");
                ++no_security;
                continue;
            }
            System.out.println("Connection failed.");
        }
        System.out.println("\n\nLow Security: Anonymous Diffie-Hellman communications in which neither party is authenticated is vulnerable to man-in-the-middle attacks. These should not be used");
        for (x = 0; x < anonCiphersuite.length; ++x) {
            System.out.println("\n\n" + (x + 1) + ". Using " + anonCiphersuite[x]);
            connect = s.scan(host, port, http_method, url, anonCiphersuite[x]);
            if (connect) {
                System.out.println("Connection successful.");
                ++anonymous;
                continue;
            }
            System.out.println("Connection failed.");
        }
        System.out.println("\n\nLow Security: These are ciphersuites with cipher key size less than 128 bit. These should not be used");
        for (x = 0; x < weakCiphersuite.length; ++x) {
            System.out.println("\n\n" + (x + 1) + ". Using " + weakCiphersuite[x]);
            connect = s.scan(host, port, http_method, url, weakCiphersuite[x]);
            if (connect) {
                System.out.println("Connection successful.");
                ++weak;
                continue;
            }
            System.out.println("Connection failed.");
        }
        System.out.println("\n\nStrong Security: These are ciphersuites with 128 bit cipher keys.");
        for (x = 0; x < strongCiphersuite.length; ++x) {
            System.out.println("\n\n" + (x + 1) + ". Using " + strongCiphersuite[x]);
            connect = s.scan(host, port, http_method, url, strongCiphersuite[x]);
            if (connect) {
                System.out.println("Connection successful.");
                ++strong;
                continue;
            }
            System.out.println("Connection failed.");
        }
        System.out.println("\nReport:");
        System.out.println("Target: " + host + ":" + port);
        System.out.println("You have " + no_security + " null ciphersuites enabled in your web server.");
        System.out.println("You have " + anonymous + " anonymous ciphersuites enabled in your web server.");
        System.out.println("You have " + weak + " weak ciphersuites enabled in your web server.");
        System.out.println("You have " + strong + " strong ciphersuites enabled in your web server.");
        httpsScanner.printAbout();
    }

    static void printAbout() {
        System.out.println("\n" + HTTPS_SCANNER_VERSION + "\n");
        System.out.println("Get the lastest copy of httpsScanner from http://libre-tools.googlecode.com\n");
        System.out.println("Author: Chan Fook Sheng\n");
        System.out.println("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License Version 3 as published by the Free Software Foundation.\n");
        System.out.println("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
        System.out.println("You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.");
    }
}

