﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Collections.ObjectModel;

namespace FuzzTalk
{
    public partial class FuzzTalkScriptConfiguration
    {
        private int stringOverflowSizeField;

        private int stringOverflowMultiplierField;

        private int stringOverflowMultiplierIncrementField;

        //[XmlElement("Parameters")]
        [XmlArray("Parameters")]
        public ObservableCollection<FuzzTalkScriptParameter> Parameters { get; set; }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int StringOverflowSize
        {
            get
            {
                return this.stringOverflowSizeField;
            }
            set
            {
                this.stringOverflowSizeField = value;
                this.RaisePropertyChanged("StringOverflowSize");
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int StringOverflowMultiplier
        {
            get
            {
                return this.stringOverflowMultiplierField;
            }
            set
            {
                this.stringOverflowMultiplierField = value;
                this.RaisePropertyChanged("StringOverflowMultiplier");
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int StringOverflowMultiplierIncrement
        {
            get
            {
                return this.stringOverflowMultiplierIncrementField;
            }
            set
            {
                this.stringOverflowMultiplierIncrementField = value;
                this.RaisePropertyChanged("StringOverflowMultiplierIncrement");
            }
        }

        private bool _permute = true;
        
        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool Permute
        {
            get { return _permute; }
            set { _permute = value; }
        }

        private bool _singleComponentMode = false;

        [System.Xml.Serialization.XmlAttributeAttribute()]
        public bool SingleComponentMode
        {
            get { return _singleComponentMode; }
            set { _singleComponentMode = value; }
        }

        private int _maxSize = -1;

        [System.Xml.Serialization.XmlAttributeAttribute()]
        public int MaxSize
        {
            get { return _maxSize; }
            set { _maxSize = value; }
        }
    }
}
