﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace DllImportTest.Debugger
{
    public delegate void Callback(DebuggerMessage Value);

    public class NativeDebugger
    {
        const string DllPath = @"C:\Users\Johnny Cake\Documents\Visual Studio 2008\Projects\Blog\ArtOfExploitation\DllImportTest\Debug\DebuggerComponents.dll";

        [DllImport(DllPath)]
        private static extern void StartProcess(string Path,
            [MarshalAs(UnmanagedType.FunctionPtr)]Callback Callback);

        [DllImport(DllPath)]
        private static extern void Attach(int ProcessId,
            [MarshalAs(UnmanagedType.FunctionPtr)]Callback Callback);

        public event EventHandler<ExceptionEventArgs> ExceptionCaught;

        public bool Running { get; private set; }

        private void RaiseExceptionCaught(ExceptionInfo Exception)
        {
            var handle = ExceptionCaught;

            if (handle != null)
                handle(this, new ExceptionEventArgs(Exception));
        }

        private void AssertNotRunning()
        {
            if (Running)
                throw new InvalidOperationException("The debugger is already running.");
        }

        private void DebugCallback(DebuggerMessage Message)
        {
            if (Message.MessageType == DebugMessageType.Exception)
            {
                RaiseExceptionCaught(Message.Exception);
            }
        }

        public void DebugProcess(string Path)
        {
            AssertNotRunning();

            Running = true;

            StartProcess(Path, DebugCallback);
        }
    }
}
