// Debugger.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <time.h>
#include <string.h>


using namespace std;

DWORD _startTick = GetTickCount();

DWORD _fileIndex = 0;

char* _debuggerConfiguration;

char* CreateCharArray(int Size)
{
	char* c = new char[Size];

	memset(c, 0, Size);

	return c;
}

void ShowError(char* error)
{
	printf("%s\r\nError Code: %u\r\n\r\n", error, GetLastError());
	
	system("pause");
	exit(-1);
}

char* ExceptionCodeToString(DWORD ExceptionCode)
{
	switch (ExceptionCode)
	{
		case EXCEPTION_ACCESS_VIOLATION: return "ACCESS_VIOLATION";
		case EXCEPTION_DATATYPE_MISALIGNMENT: return "DATATYPE_MISALIGNMENT";
		case EXCEPTION_BREAKPOINT: return "BREAKPOINT";
		case EXCEPTION_SINGLE_STEP: return "SINGLE_STEP";
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED: return "ARRAY_BOUNDS_EXCEEDED";
		case EXCEPTION_FLT_DENORMAL_OPERAND: return "FLT_DENORMAL_OPERAND";
		case EXCEPTION_FLT_DIVIDE_BY_ZERO: return "FLT_DIVIDE_BY_ZERO";
		case EXCEPTION_FLT_INEXACT_RESULT: return "FLT_INEXACT_RESULT";
		case EXCEPTION_FLT_INVALID_OPERATION: return "FLT_INVALID_OPERATION";
		case EXCEPTION_FLT_OVERFLOW: return "FLT_OVERFLOW";
		case EXCEPTION_FLT_STACK_CHECK: return "FLT_STACK_CHECK";
		case EXCEPTION_FLT_UNDERFLOW: return "FLT_UNDERFLOW";
		case EXCEPTION_INT_DIVIDE_BY_ZERO: return "INT_DIVIDE_BY_ZERO";
		case EXCEPTION_INT_OVERFLOW: return "INT_OVERFLOW";
		case EXCEPTION_PRIV_INSTRUCTION: return "PRIV_INSTRUCTION";
		case EXCEPTION_IN_PAGE_ERROR: return "IN_PAGE_ERROR";
		case EXCEPTION_ILLEGAL_INSTRUCTION: return "ILLEGAL_INSTRUCTION";
		case EXCEPTION_NONCONTINUABLE_EXCEPTION: return "NONCONTINUABLE_EXCEPTION";
		case EXCEPTION_STACK_OVERFLOW: return "STACK_OVERFLOW";
		case EXCEPTION_INVALID_DISPOSITION: return "INVALID_DISPOSITION";
		case EXCEPTION_GUARD_PAGE: return "GUARD_PAGE";
		case EXCEPTION_INVALID_HANDLE: return "INVALID_HANDLE";
	}

	return 0;	
}

char* GetThreadRegisters(HANDLE hThread)
{
	LPCONTEXT pContext = new CONTEXT();
	pContext->ContextFlags = CONTEXT_ALL;	

	if (!GetThreadContext(hThread, pContext))
		ShowError("Error getting thread context");

	//_lastEip = pContext->Eip;

	char* dump = CreateCharArray(8192);

	sprintf(dump, 
		"Edi = %08x\r\n"
		"Esi = %08x\r\n"
		"Ebx = %08x\r\n"
		"Edx = %08x\r\n"
		"Ecx = %08x\r\n"
		"Eax = %08x\r\n"
		"Ebp = %08x\r\n"
		"Esp = %08x\r\n"
		"Eip = %08x\r\n"
		"\r\n",
		pContext->Edi, pContext->Esi, pContext->Ebx,
		pContext->Edx, pContext->Ecx, pContext->Eax,
		pContext->Ebp, pContext->Esp, pContext->Eip);

	return dump;
}

void DumpDebugEvent(DEBUG_EVENT* debugEvent)
{
	EXCEPTION_RECORD record = debugEvent->u.Exception.ExceptionRecord;

	if (record.ExceptionCode == EXCEPTION_BREAKPOINT)
		return;	

	char* exceptionCodeMsg = CreateCharArray(512);	

	char* codeString = ExceptionCodeToString(record.ExceptionCode);

	BOOL unknown = FALSE;

	if (!codeString)
	{
		unknown = TRUE;

		//delete[] codeString;

		codeString = CreateCharArray(512);
		
		sprintf(codeString, "Unknown Exception Code %u\r\n", record.ExceptionCode);
	}

	sprintf(exceptionCodeMsg, "Exception = %s\r\n", codeString);

	printf(exceptionCodeMsg);

	char* exceptionAddressMsg = CreateCharArray(512);

	sprintf(exceptionAddressMsg, "Exception Address = %08x\r\n", record.ExceptionAddress);

	printf(exceptionAddressMsg);

	char* exceptionInformationMsg = CreateCharArray(512);

	if (record.ExceptionCode == EXCEPTION_ACCESS_VIOLATION ||
		record.ExceptionCode == EXCEPTION_IN_PAGE_ERROR)
	{
		
		char* accessViolationType = CreateCharArray(128);

		if (!record.ExceptionInformation[0])
			accessViolationType = "Read";
		else if (record.ExceptionInformation[0] == 1)
			accessViolationType = "Write";
		else if (record.ExceptionInformation[0] == 8)
			accessViolationType = "DEP";

		sprintf(exceptionInformationMsg, 
			"Exception Information = %s violation at %08x\r\n", 
			accessViolationType, record.ExceptionInformation[1]);

		printf(exceptionInformationMsg);
	}	

	HANDLE hThread = OpenThread(THREAD_GET_CONTEXT, 0, debugEvent->dwThreadId);

	char* registersMsg = GetThreadRegisters(hThread);

	printf(registersMsg);

	CloseHandle(hThread);	

	if (unknown)
		return;

	char* path = CreateCharArray(8192);

	GetCurrentDirectoryA(8192, path);

	string pathString(path);
	
	stringstream timestream;
	timestream << _startTick;
	timestream << _fileIndex++;

	/*Sleep(1);	*/
	
	/*string s = pathString + "\\" +  timestream.str() + ".dmp";*/
	string s = pathString + "\\" +  timestream.str() + ".dmp";

	printf("Writing dump to %s\r\n\r\n", s.c_str());

	ofstream outputStream;
	outputStream.open(s.c_str());

	outputStream << string(_debuggerConfiguration);
	outputStream << exceptionCodeMsg;
	outputStream << exceptionAddressMsg;
	outputStream << exceptionInformationMsg;
	outputStream << registersMsg;

	outputStream.close();
}



int main(int argc, char* argv[])
{
	_debuggerConfiguration = CreateCharArray(8192);

	//for (int i = 0; i < 20; i++)
	//{
	//	printf("%i\n", GetTickCount());
	//}

	//system("Pause");

	if (!strcmp(argv[1], "-s"))
	{
		char* pCurrentDirectory;
		STARTUPINFOA* pStartupInfo = new STARTUPINFOA();
		pStartupInfo->cb = sizeof STARTUPINFOA;
		/*pStartupInfo->dwFlags = STARTF_USESHOWWINDOW;
		pStartupInfo->wShowWindow = SW_HIDE;*/
		PROCESS_INFORMATION* pProcessInfo = new PROCESS_INFORMATION();

		string sArgs = "";		

		if (argc == 4)
			sArgs = "\"" + string(argv[3]) + "\"";

		char* args = CreateCharArray(8192);

		if (sArgs != "")
			args = (char*)sArgs.c_str();

		string sAppPath = "\"" + string(argv[2]) + "\" " + args;

		/*printf("%s\r\n", sAppPath.c_str());*/

		sprintf(_debuggerConfiguration, 
			"Application: %s\r\n"
			"Arguments: %s\r\n\r\n", 
			argv[2], args);

		printf(_debuggerConfiguration);

		char *pAppPath = (char*)sAppPath.c_str();

		/*if (!CreateProcessA(0, pAppPath, 0, 0, 0, DEBUG_PROCESS | CREATE_NO_WINDOW, 0, 0,*/
		if (!CreateProcessA(0, pAppPath, 0, 0, 0, DEBUG_PROCESS, 0, 0,
			pStartupInfo, pProcessInfo))
			ShowError("CreateProcessA call failed");
	}
	else
	{
		int processId = atoi(argv[1]);

		if (DebugActiveProcess(processId) == 0)
			ShowError("DebugActiveProcess call failed");

		if (!DebugSetProcessKillOnExit(0))
			ShowError("DebugSetProcessKillOnExit call failed");

		printf("Attached to %i\r\n", processId);
	}

	

	while (1)
	{
		DEBUG_EVENT debugEvent;
		
		WaitForDebugEvent(&debugEvent, -1);

		DWORD dwContinueStatus;

		if (debugEvent.dwDebugEventCode == EXCEPTION_DEBUG_EVENT)
		{
			DumpDebugEvent(&debugEvent);

			dwContinueStatus = DBG_EXCEPTION_NOT_HANDLED;
		}
		else
			dwContinueStatus = DBG_CONTINUE;

		ContinueDebugEvent(debugEvent.dwProcessId, 
			debugEvent.dwThreadId, dwContinueStatus);
	}

	return 0;
}

