package exploitpack;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author jsacco
 */
public class XMLTreenode {

    public String ExploitName;
    public String CodeName;
    public String ExploitType;
    public String Platform;
    public String Service;
    public String RemotePort;
    public String LocalPort;
    public String ShellPort;
    public String ShellcodeAvailable;
    public String Vulnerability;
    public String Author;
    public String Information;
    public String Date;
    public String Targets;
    public String SpecialArgs;

    public void main(String[] args, String XMLName) {

        try {
            InputStream inputStream = new FileInputStream("exploits/" + XMLName);
            Reader reader = new InputStreamReader(inputStream, "UTF-8");
            InputSource is = new InputSource(reader);

            is.setEncoding("UTF-8");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(is);

            Node Exploit = (Node) (XPathFactory.newInstance().newXPath().evaluate("/Module/Exploit", doc, XPathConstants.NODE));
            if (Exploit != null) {
                ExploitName = Exploit.getAttributes().getNamedItem("NameXML").getTextContent();
                CodeName = Exploit.getAttributes().getNamedItem("CodeName").getTextContent();
                Service = Exploit.getAttributes().getNamedItem("Service").getTextContent();
                Platform = Exploit.getAttributes().getNamedItem("Platform").getTextContent();
                ExploitType = Exploit.getAttributes().getNamedItem("Type").getTextContent();
                RemotePort = Exploit.getAttributes().getNamedItem("RemotePort").getTextContent();
                LocalPort = Exploit.getAttributes().getNamedItem("LocalPort").getTextContent();
                ShellcodeAvailable = Exploit.getAttributes().getNamedItem("ShellcodeAvailable").getTextContent();
                ShellPort = Exploit.getAttributes().getNamedItem("ShellPort").getTextContent();
                SpecialArgs = Exploit.getAttributes().getNamedItem("SpecialArgs").getTextContent();
            } else {
                System.out.println("error: " + XMLName);
            }

            Node Info = (Node) (XPathFactory.newInstance().newXPath().evaluate("/Module/Information", doc, XPathConstants.NODE));
            if (Info != null) {
                Information = Info.getTextContent();
                Author = Info.getAttributes().getNamedItem("Author").getTextContent();
                Date = Info.getAttributes().getNamedItem("Date").getTextContent();
                Vulnerability = Info.getAttributes().getNamedItem("Vulnerability").getTextContent();
            }

            Node Target = (Node) (XPathFactory.newInstance().newXPath().evaluate("/Module/Targets", doc, XPathConstants.NODE));
            if (Targets != null) {
                Targets = Target.getTextContent();
            }

            Element elementRaiz = doc.getDocumentElement();
            NodeList hijos = elementRaiz.getChildNodes();
            for (int i = 0; i < hijos.getLength(); i++) {
                Node nodo = hijos.item(i);
                if (nodo instanceof Element) {
                }
            }

        } catch (FileNotFoundException e) {
            System.out.println("Error Parsing file: " + XMLName + e);
        } catch (SAXException | XPathExpressionException | ParserConfigurationException | IOException | NullPointerException e) {
            System.out.println("Error Parsing file: " + XMLName + e);
        }
    }
}
