/*
 * Copyright (C) 2016 jsacco
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package exploitpack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level; 
import java.util.logging.Logger;

/**
 *
 * @author jsacco
 */
public class GDB {

    public static void main(String[] commands) {      
        try {
            String line;
            OutputStream stdin = null;
            InputStream stderr = null;
            InputStream stdout = null;
            
            // launch EXE and grab stdin/stdout and stderr
            Process process = Runtime.getRuntime ().exec ("gdb -q --interpreter=mi2");
            stdin = process.getOutputStream ();
            stderr = process.getErrorStream ();
            stdout = process.getInputStream ();
            
            // "write" the parms into stdin
            line = "file /bin/ls" + "\n";
            stdin.write(line.getBytes() );
            stdin.flush();
            stdin.close();
            
            // clean up if any output in stdout
            BufferedReader brCleanUp =
                    new BufferedReader (new InputStreamReader (stdout));
            while ((line = brCleanUp.readLine ()) != null) {
                System.out.println (line);
            }
            brCleanUp.close();
            
            // clean up if any output in stderr
            brCleanUp =
                    new BufferedReader (new InputStreamReader (stderr));
            while ((line = brCleanUp.readLine ()) != null) {
                System.out.println (line);
            }
            
            brCleanUp.close();
        } catch (IOException ex) {
            Logger.getLogger(GDB.class.getName()).log(Level.SEVERE, null, ex);
        }

    }
}
