/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OpenFile {
    private JTextArea txt;
    FileNameExtensionFilter EXEfilter = new FileNameExtensionFilter("EXE Files", "exe");
    FileNameExtensionFilter Imagefilter = new FileNameExtensionFilter("Image Files", "png");
    File file = null;
    File outFile = null;
    FileInputStream fstream = null;
    DataInputStream in = null;
    static byte[] imagebytes;

    public OpenFile(JTextArea textArea) {
        this.txt = textArea;
    }

    public void pickFile() throws Exception {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(this.Imagefilter);
        fileChooser.setFileFilter(this.EXEfilter);
        if (fileChooser.showOpenDialog(null) == 0) {
            this.file = fileChooser.getSelectedFile();
        } else {
            JOptionPane.showMessageDialog(null, "No File Chosen", "Error", 2);
        }
    }

    public void pickDir() throws Exception {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showSaveDialog(null) == 0) {
            this.outFile = fileChooser.getSelectedFile();
        } else {
            JOptionPane.showMessageDialog(null, "No File Chosen", "Error", 2);
        }
    }

    public String ext(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    public void EXEtoImage(JProgressBar bar, String color) throws Exception {
        bar.setIndeterminate(false);
        int count = 0;
        this.fstream = new FileInputStream(this.file);
        this.in = new DataInputStream(this.fstream);
        byte[] b = new byte[this.in.available()];
        while (this.in.available() != 0) {
            b[count] = this.in.readByte();
            ++count;
        }
        this.in.close();
        imagebytes = b;
        int c = 0;
        int c2 = 1;
        int size = (int)Math.sqrt(b.length) + 2;
        BufferedImage buff = new BufferedImage(size, size, 1);
        this.txt.append("Creating image . . . 0/" + Integer.toString(b.length));
        int y = 0;
        while (y < size) {
            bar.setValue(y);
            this.txt.append("\nCreating image . . . " + Integer.toString(c) + "/" + Integer.toString(b.length));
            int x = 0;
            while (x < size) {
                if (c < b.length - 1) {
                    int rgb;
                    int b2;
                    int g;
                    int r;
                    if (color.equals("red")) {
                        r = b[c];
                        g = c2;
                        b2 = c2++;
                        rgb = 0xFF | r << 16 | g << 8 | b2;
                        buff.setRGB(x, y, rgb);
                        ++c;
                        if (c2 == 253) {
                            c2 = 1;
                        }
                    } else if (color.equals("green")) {
                        r = c2;
                        g = b[c];
                        b2 = c2++;
                        rgb = 0xFF000000 | r << 16 | g << 8 | b2;
                        buff.setRGB(x, y, rgb);
                        ++c;
                        if (c2 == 253) {
                            c2 = 1;
                        }
                    } else if (color.equals("blue")) {
                        r = c2;
                        g = c2++;
                        b2 = b[c];
                        rgb = 0xFF000000 | r << 16 | g << 8 | b2;
                        buff.setRGB(x, y, rgb);
                        ++c;
                        if (c2 == 253) {
                            c2 = 1;
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
        String out = String.valueOf(this.file.getName()) + ".png";
        this.txt.append("\nFile Saved to: \n" + this.outFile + "\\" + out);
        ImageIO.write((RenderedImage)buff, "png", new File(this.outFile + "\\" + out));
    }

    public void ImagetoEXE(JProgressBar bar, String color) throws Exception {
        bar.setIndeterminate(false);
        BufferedImage image = ImageIO.read(this.file);
        byte[] b = new byte[image.getHeight() * image.getWidth()];
        int xmax = image.getWidth() - 1;
        int ymax = image.getHeight() - 1;
        int count = 0;
        int y = 0;
        while (y <= ymax) {
            bar.setValue(y);
            this.txt.append("\nCreating exe . . . " + Integer.toString(count) + "/" + Integer.toString(b.length));
            int x = 0;
            while (x <= xmax) {
                int pixel;
                if (color.equals("red")) {
                    pixel = image.getRGB(x, y);
                    int red = pixel >> 16 & 0xFF;
                    b[count] = (byte)red;
                    ++count;
                } else if (color.equals("green")) {
                    pixel = image.getRGB(x, y);
                    int green = pixel >> 8 & 0xFF;
                    b[count] = (byte)green;
                    ++count;
                } else if (color.equals("blue")) {
                    pixel = image.getRGB(x, y);
                    int blue = pixel & 0xFF;
                    b[count] = (byte)blue;
                    ++count;
                }
                ++x;
            }
            ++y;
        }
        String out = String.valueOf(this.file.getName()) + ".exe";
        this.txt.append("\nFile Saved to: \n" + this.outFile + "\\" + out);
        FileOutputStream fos = new FileOutputStream(this.outFile + "\\" + out);
        fos.write(b);
        fos.close();
    }
}

