/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui.JTableTree;

import com.sittinglittleduck.DirBuster.gui.JTableTree.TreeTableModel;
import com.sittinglittleduck.DirBuster.gui.JTableTree.TreeTableModelEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                int row = TreeTableModelAdapter.this.tree.getRowForPath(e.getTreePath());
                if (row < 0) {
                    return;
                }
                Object[] children = e.getChildren();
                Object[] path = e.getTreePath().getPath();
                Object[] childPath = new Object[path.length + 1];
                System.arraycopy(path, 0, childPath, 0, path.length);
                childPath[childPath.length - 1] = children[0];
                TreePath firstChildChanged = new TreePath(childPath);
                int firstRow = TreeTableModelAdapter.this.tree.getRowForPath(firstChildChanged);
                childPath[childPath.length - 1] = children[children.length - 1];
                TreePath lastChildChanged = new TreePath(childPath);
                int lastRow = TreeTableModelAdapter.this.tree.getRowForPath(lastChildChanged);
                if (firstRow * lastRow < 0) {
                    System.err.println("First row is " + firstRow + " and last row is " + lastRow);
                }
                if (firstRow < 0 || lastRow < 0) {
                    return;
                }
                if (e instanceof TreeTableModelEvent && firstRow == lastRow) {
                    int column = ((TreeTableModelEvent)e).getColumn();
                    TreeTableModelAdapter.this.delayedFireTableCellUpdated(firstRow, column);
                } else {
                    TreeTableModelAdapter.this.delayedFireTableRowsUpdated(firstRow, lastRow);
                }
            }

            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableStructureChanged();
            }
        });
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    public Object getRowNode(int row) {
        return this.nodeForRow(row);
    }

    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    protected void delayedFireTableCellUpdated(final int row, final int column) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableCellUpdated(row, column);
            }
        });
    }

    protected void delayedFireTableRowsUpdated(final int first, final int last) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableRowsUpdated(first, last);
            }
        });
    }

    protected void delayedFireTableStructureChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableStructureChanged();
            }
        });
    }
}

