/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.VersionMap;

public class OpcodeUtils {
    public static Opcodes getOpcodesFromDexVersion(int dexVersion) {
        return Opcodes.forDexVersion(dexVersion);
    }

    public static int getDexVersionFromOpcodes(Opcodes opcodes) {
        if (opcodes.api == -1) {
            throw OpcodeUtils.undefinedApiLevel();
        }
        return VersionMap.mapApiToDexVersion(opcodes.api);
    }

    public static Opcodes getNewestOpcodes(Opcodes o1, Opcodes o2, boolean nullable) {
        if (nullable) {
            if (o1 == null) {
                return o2;
            }
            if (o2 == null) {
                return o1;
            }
        }
        if (o1.api == -1 || o2.api == -1) {
            throw OpcodeUtils.undefinedApiLevel();
        }
        return o1.api >= o2.api ? o1 : o2;
    }

    private static IllegalArgumentException undefinedApiLevel() {
        return new IllegalArgumentException("Opcodes instance has undefined api level");
    }

    private OpcodeUtils() {
    }
}

