/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lanchon.multidexlib2.BatchedIterator;
import lanchon.multidexlib2.DexFileNameIterator;
import lanchon.multidexlib2.DexPoolOverflowException;
import lanchon.multidexlib2.SingletonDexContainer;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.dexlib2.writer.pool.DexPool;

public class DexIO {
    public static final int DEFAULT_MAX_DEX_POOL_SIZE = 65536;
    private static final int PER_THREAD_BATCH_SIZE = 100;

    private DexIO() {
    }

    static void writeRawDexSingleThread(DexDataStore dataStore, DexFile dexFile, int maxDexPoolSize, Logger logger, File file) throws IOException {
        Set<? extends ClassDef> classes = dexFile.getClasses();
        Iterator<? extends ClassDef> classIterator = classes.iterator();
        DexPool dexPool = new DexPool(dexFile.getOpcodes());
        int classCount = 0;
        while (classIterator.hasNext()) {
            ClassDef classDef = classIterator.next();
            dexPool.internClass(classDef);
            if (dexPool.hasOverflowed(maxDexPoolSize)) {
                DexIO.handleDexPoolOverflow(classDef, classCount, classes.size());
                throw new AssertionError((Object)"unexpected type count");
            }
            ++classCount;
        }
        if (logger != null) {
            logger.log(file, SingletonDexContainer.UNDEFINED_ENTRY_NAME, classCount);
        }
        dexPool.writeTo(dataStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeMultiDexDirectorySingleThread(boolean multiDex, File directory, DexFileNameIterator nameIterator, DexFile dexFile, int minMainDexClassCount, boolean minimalMainDex, int maxDexPoolSize, Logger logger) throws IOException {
        Object lock;
        Set<? extends ClassDef> classes = dexFile.getClasses();
        if (!multiDex) {
            minMainDexClassCount = classes.size();
            minimalMainDex = false;
        }
        Object object = lock = new Object();
        synchronized (object) {
            DexIO.writeMultiDexDirectoryCommon(directory, nameIterator, Iterators.peekingIterator(classes.iterator()), minMainDexClassCount, minimalMainDex, dexFile.getOpcodes(), maxDexPoolSize, logger, lock);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void writeMultiDexDirectoryMultiThread(int threadCount, final File directory, final DexFileNameIterator nameIterator, final DexFile dexFile, final int maxDexPoolSize, final Logger logger) throws IOException {
        Iterator<? extends ClassDef> classIterator = dexFile.getClasses().iterator();
        final Object lock = new Object();
        ArrayList<1> callables = new ArrayList<1>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            final BatchedIterator<? extends ClassDef> batchedIterator = new BatchedIterator<ClassDef>(classIterator, lock, 100);
            if (i != 0 && !batchedIterator.hasNext()) break;
            callables.add(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    DexIO.writeMultiDexDirectoryCommon(directory, nameIterator, batchedIterator, 0, false, dexFile.getOpcodes(), maxDexPoolSize, logger, lock);
                    return null;
                }
            });
        }
        ExecutorService service = Executors.newFixedThreadPool(threadCount);
        try {
            List futures = service.invokeAll(callables);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    Throwable c = e.getCause();
                    if (c instanceof IOException) {
                        throw (IOException)c;
                    }
                    if (c instanceof RuntimeException) {
                        throw (RuntimeException)c;
                    }
                    if (!(c instanceof Error)) throw new UndeclaredThrowableException(c);
                    throw (Error)c;
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMultiDexDirectoryCommon(File directory, DexFileNameIterator nameIterator, PeekingIterator<? extends ClassDef> classIterator, int minMainDexClassCount, boolean minimalMainDex, Opcodes opcodes, int maxDexPoolSize, Logger logger, Object lock) throws IOException {
        do {
            File file;
            int fileClassCount;
            DexPool dexPool = new DexPool(opcodes);
            for (fileClassCount = 0; classIterator.hasNext() && (!minimalMainDex || fileClassCount < minMainDexClassCount); ++fileClassCount) {
                ClassDef classDef = classIterator.peek();
                dexPool.mark();
                dexPool.internClass(classDef);
                if (dexPool.hasOverflowed(maxDexPoolSize)) {
                    DexIO.handleDexPoolOverflow(classDef, fileClassCount, minMainDexClassCount);
                    dexPool.reset();
                    break;
                }
                classIterator.next();
            }
            Object object = lock;
            synchronized (object) {
                String name = nameIterator.next();
                file = new File(directory, name);
                if (logger != null) {
                    logger.log(directory, name, fileClassCount);
                }
                if (classIterator instanceof BatchedIterator) {
                    ((BatchedIterator)classIterator).preloadBatch();
                }
            }
            dexPool.writeTo(new FileDataStore(file));
            minMainDexClassCount = 0;
            minimalMainDex = false;
        } while (classIterator.hasNext());
    }

    private static void handleDexPoolOverflow(ClassDef classDef, int classCount, int minClassCount) {
        if (classCount < minClassCount) {
            throw new DexPoolOverflowException("Dex pool overflowed while writing type " + (classCount + 1) + " of " + minClassCount);
        }
        if (classCount == 0) {
            throw new DexPoolOverflowException("Type too big for dex pool: " + classDef.getType());
        }
    }

    public static interface Logger {
        public void log(File var1, String var2, int var3);
    }
}

