/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import lanchon.multidexlib2.DexFileNamer;

public class BasicDexFileNamer
implements DexFileNamer {
    public static final String DEFAULT_PREFIX = "classes";
    public static final String DEFAULT_SUFFIX = ".dex";
    public static final String DEFAULT_BASE_NAME = "classes.dex";
    private final String prefix;
    private final String suffix;

    public BasicDexFileNamer() {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX);
    }

    public BasicDexFileNamer(String baseName) {
        if (!baseName.endsWith(DEFAULT_SUFFIX)) {
            throw new IllegalArgumentException("Invalid dex file base name");
        }
        this.prefix = baseName.substring(0, baseName.length() - DEFAULT_SUFFIX.length());
        this.suffix = DEFAULT_SUFFIX;
    }

    public BasicDexFileNamer(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public String getName(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index");
        }
        return this.prefix + (index > 0 ? Integer.valueOf(index + 1) : "") + this.suffix;
    }

    @Override
    public int getIndex(String name) {
        int i;
        if (!name.startsWith(this.prefix) || !name.endsWith(this.suffix)) {
            return -1;
        }
        String s = name.substring(this.prefix.length(), name.length() - this.suffix.length());
        if (s.length() == 0) {
            return 0;
        }
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (i < 2 || !s.equals(String.valueOf(i))) {
            return -1;
        }
        return i - 1;
    }

    @Override
    public boolean isValidName(String name) {
        return this.getIndex(name) >= 0;
    }
}

