/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.util;

import java.util.Iterator;
import lanchon.dexpatcher.core.Marker;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;

public class DexUtils {
    public static boolean isClassDescriptor(String descriptor) {
        int l = descriptor.length();
        return l >= 2 && descriptor.charAt(0) == 'L' && descriptor.charAt(l - 1) == ';';
    }

    public static int getClassAccessFlags(ClassDef classDef) {
        int f = classDef.getAccessFlags();
        for (Annotation annotation : classDef.getAnnotations()) {
            if (!Marker.TYPE_INNER_CLASS.equals(annotation.getType())) continue;
            for (AnnotationElement annotationElement : annotation.getElements()) {
                EncodedValue v;
                if (!"accessFlags".equals(annotationElement.getName()) || !((v = annotationElement.getValue()) instanceof IntEncodedValue)) continue;
                f |= ((IntEncodedValue)v).getValue();
            }
        }
        return f;
    }

    public static boolean isStaticConstructor(String methodId, Method method) {
        int bits;
        int mask = bits = AccessFlags.CONSTRUCTOR.getValue() | AccessFlags.STATIC.getValue();
        return (method.getAccessFlags() & mask) == bits && "<clinit>..V".equals(methodId);
    }

    public static boolean isInstanceConstructor(String methodId, Method method) {
        int bits = AccessFlags.CONSTRUCTOR.getValue();
        int mask = bits | AccessFlags.STATIC.getValue();
        return (method.getAccessFlags() & mask) == bits && "<init>".equals(method.getName());
    }

    public static boolean isDefaultConstructor(String methodId, Method method) {
        int bits = AccessFlags.CONSTRUCTOR.getValue();
        int mask = bits | AccessFlags.STATIC.getValue();
        return (method.getAccessFlags() & mask) == bits && "<init>..V".equals(methodId);
    }

    public static boolean hasTrivialConstructorImplementation(Method method) {
        MethodImplementation implementation = method.getImplementation();
        if (implementation.getRegisterCount() != 1 || !implementation.getTryBlocks().isEmpty()) {
            return false;
        }
        Iterator<? extends Instruction> iterator = implementation.getInstructions().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Instruction instruction = iterator.next();
        if (instruction.getOpcode() != Opcode.INVOKE_DIRECT) {
            return false;
        }
        MethodReference reference = (MethodReference)((ReferenceInstruction)instruction).getReference();
        if (!"<init>".equals(reference.getName())) {
            return false;
        }
        if (method.getDefiningClass().equals(reference.getDefiningClass())) {
            return false;
        }
        if (!iterator.hasNext()) {
            return false;
        }
        instruction = iterator.next();
        if (instruction.getOpcode() != Opcode.RETURN_VOID) {
            return false;
        }
        return !iterator.hasNext();
    }

    private DexUtils() {
    }
}

