/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import java.util.regex.Pattern;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.PatcherAnnotation;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.patcher.ClassSetPatcher;
import lanchon.dexpatcher.core.util.DexUtils;
import lanchon.dexpatcher.core.util.Id;
import lanchon.dexpatcher.core.util.Label;
import lanchon.dexpatcher.core.util.TypeName;
import org.jf.dexlib2.iface.ClassDef;

public class PackagePatcher
extends ClassSetPatcher {
    private static final String PACKAGE_SUFFIX = "package-info;";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("(?s)L(.*/)?" + Pattern.quote("package-info") + ';');
    private boolean processingPackage;

    private static boolean isPackageId(String id) {
        String descriptor = Id.toClassDescriptor(id);
        return descriptor.endsWith(PACKAGE_SUFFIX) && PACKAGE_PATTERN.matcher(descriptor).matches();
    }

    public PackagePatcher(Context context) {
        super(context);
    }

    @Override
    protected void onPrepare(String patchId, ClassDef patch, PatcherAnnotation annotation) throws PatchException {
        this.processingPackage = PackagePatcher.isPackageId(patchId);
        if (!this.processingPackage) {
            super.onPrepare(patchId, patch, annotation);
            return;
        }
        if (annotation.getTargetClass() != null) {
            throw PatcherAnnotation.invalidElement("targetClass");
        }
        if (annotation.getContentOnly()) {
            throw PatcherAnnotation.invalidElement("contentOnly");
        }
    }

    @Override
    protected void onReplace(String patchId, ClassDef patch, PatcherAnnotation annotation) throws PatchException {
        if (!this.processingPackage) {
            super.onReplace(patchId, patch, annotation);
            return;
        }
        String targetId = this.getPackageTargetId(patchId, patch, annotation);
        boolean recursive = annotation.getRecursive();
        if (this.isLogging(Logger.Level.DEBUG)) {
            this.log(Logger.Level.DEBUG, recursive ? "replace package recursive" : "replace package non-recursive");
        }
        this.removePackage(targetId, recursive);
        ClassDef patched = this.onSimpleAdd(patch, annotation);
        this.addPatched(patch, patched);
    }

    @Override
    protected void onRemove(String patchId, ClassDef patch, PatcherAnnotation annotation) throws PatchException {
        if (!this.processingPackage) {
            super.onRemove(patchId, patch, annotation);
            return;
        }
        String targetId = this.getPackageTargetId(patchId, patch, annotation);
        boolean recursive = annotation.getRecursive();
        if (this.isLogging(Logger.Level.DEBUG)) {
            this.log(Logger.Level.DEBUG, recursive ? "remove package recursive" : "remove package non-recursive");
        }
        this.removePackage(targetId, recursive);
    }

    private String getPackageTargetId(String patchId, ClassDef patch, PatcherAnnotation annotation) throws PatchException {
        String targetId = patchId;
        String target = annotation.getTarget();
        if (target != null) {
            String targetDescriptor;
            if (DexUtils.isClassDescriptor(target)) {
                targetDescriptor = target;
            } else {
                if (target.startsWith(".")) {
                    target = target.substring(1);
                }
                target = target.length() != 0 ? target + ".package-info" : "package-info";
                targetDescriptor = TypeName.toClassDescriptor(target);
            }
            targetId = Id.fromClassDescriptor(targetDescriptor);
        }
        if (!PackagePatcher.isPackageId(targetId)) {
            throw new PatchException("target is not a package");
        }
        if (this.shouldLogTarget(patchId, targetId)) {
            this.extendLogPrefixWithTargetLabel(Label.fromClassId(targetId));
        }
        return targetId;
    }

    private void removePackage(String targetId, boolean recursive) throws PatchException {
        String prefix = targetId.substring(0, targetId.length() - PACKAGE_SUFFIX.length());
        Pattern pattern = Pattern.compile("(?s)" + Pattern.quote(prefix) + (recursive ? ".*;" : "[^/]*;"));
        for (String id : this.getSourceMap().keySet()) {
            if (!id.startsWith(prefix) || !pattern.matcher(id).matches()) continue;
            try {
                this.addTarget(id, false);
                if (!this.isLogging(Logger.Level.DEBUG)) continue;
                this.log(Logger.Level.DEBUG, "remove type '" + Label.fromClassId(id) + "'");
            }
            catch (PatchException e) {
                this.log(Logger.Level.ERROR, "already targeted type '" + Label.fromClassId(id) + "'");
            }
        }
    }
}

