/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.Marker;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.PatcherAnnotation;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.model.BasicField;
import lanchon.dexpatcher.core.patcher.ClassSetPatcher;
import lanchon.dexpatcher.core.patcher.MemberSetPatcher;
import lanchon.dexpatcher.core.util.Id;
import lanchon.dexpatcher.core.util.Label;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.FieldUtil;

public class FieldSetPatcher
extends MemberSetPatcher<Field> {
    public FieldSetPatcher(ClassSetPatcher parent, PatcherAnnotation annotation) {
        super(parent, annotation);
    }

    @Override
    protected void setupLogPrefix(String id, Field item, Field patch, Field patched) {
        this.setupLogPrefix(this.getItemLabel() + " '" + Label.ofField(item) + "'");
    }

    @Override
    protected final String getId(Field item) {
        return Id.ofField(item);
    }

    @Override
    protected String getItemLabel() {
        return "field";
    }

    @Override
    protected void onPrepare(String patchId, Field patch, PatcherAnnotation annotation) throws PatchException {
        if (annotation.getAction() == Action.REPLACE) {
            throw PatcherAnnotation.invalidAnnotation(Marker.REPLACE);
        }
        super.onPrepare(patchId, patch, annotation);
    }

    @Override
    protected String getTargetId(String patchId, Field patch, PatcherAnnotation annotation) {
        String targetId;
        String target = annotation.getTarget();
        String string = targetId = target != null ? Id.ofField(patch, target) : patchId;
        if (this.shouldLogTarget(patchId, targetId)) {
            this.extendLogPrefixWithTargetLabel(Label.ofTargetMember(target));
        }
        return targetId;
    }

    @Override
    protected Field onSimpleAdd(Field patch, PatcherAnnotation annotation) {
        EncodedValue value = this.filterInitialValue(patch, null);
        return new BasicField(patch.getDefiningClass(), patch.getName(), patch.getType(), patch.getAccessFlags(), value, annotation.getFilteredAnnotations());
    }

    @Override
    protected Field onSimpleEdit(Field patch, PatcherAnnotation annotation, Field target, boolean inPlace) {
        EncodedValue value = inPlace ? target.getInitialValue() : null;
        value = this.filterInitialValue(patch, value);
        this.onSimpleRemove(patch, annotation, target);
        BasicField patched = new BasicField(patch.getDefiningClass(), patch.getName(), patch.getType(), patch.getAccessFlags(), value, annotation.getFilteredAnnotations());
        return super.onSimpleEdit(patched, annotation, target, inPlace);
    }

    @Override
    protected Field onSimpleReplace(Field patch, PatcherAnnotation annotation, Field target, boolean inPlace) {
        throw new AssertionError((Object)"Replace field");
    }

    @Override
    protected void onSimpleRemove(Field patch, PatcherAnnotation annotation, Field target) {
        if (FieldUtil.isStatic(target) && AccessFlags.FINAL.isSet(target.getAccessFlags())) {
            this.log(Logger.Level.WARN, "original value of final static field is likely to be embedded in code");
        }
    }

    private EncodedValue filterInitialValue(Field patch, EncodedValue value) {
        if (FieldUtil.isStatic(patch)) {
            Action action = this.resolvedStaticConstructorAction;
            if (action.ignoresCode()) {
                this.log(Logger.Level.WARN, "static field will not be initialized as specified in patch because code of static constructor of class is being discarded");
                return value;
            }
            EncodedValue patchValue = patch.getInitialValue();
            return patchValue != null ? patchValue : value;
        }
        EncodedValue patchValue = patch.getInitialValue();
        if (patchValue != null) {
            this.log(Logger.Level.ERROR, "unexpected instance field initializer value in patch");
        }
        return patchValue != null ? patchValue : value;
    }
}

