/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import java.io.File;
import java.util.Set;
import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.PatcherAnnotation;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.patcher.ActionBasedPatcher;
import lanchon.dexpatcher.core.util.AccessFlagLogger;
import org.jf.dexlib2.iface.Annotatable;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;

public abstract class AnnotatableSetPatcher<T extends Annotatable>
extends ActionBasedPatcher<T, PatcherAnnotation> {
    private ClassDef sourceFileClass;
    private String sourceFileName;

    protected AnnotatableSetPatcher(Context context) {
        super(context);
    }

    protected AnnotatableSetPatcher(AnnotatableSetPatcher<?> parent) {
        super(parent);
        this.sourceFileClass = parent.sourceFileClass;
        this.sourceFileName = parent.sourceFileName;
    }

    protected void setSourceFileClass(ClassDef sourceFileClass) {
        this.sourceFileClass = sourceFileClass;
        this.sourceFileName = null;
    }

    protected String getSourceFileName() {
        if (this.sourceFileClass != null) {
            String type;
            int i;
            this.sourceFileName = this.sourceFileClass.getSourceFile();
            if (this.sourceFileName != null && this.getContext().getSourceCodeRoot() != null && (i = (type = this.sourceFileClass.getType()).lastIndexOf(47)) >= 1) {
                String path = type.substring(1, i + 1).replace('/', File.separatorChar);
                this.sourceFileName = path + this.sourceFileName;
            }
            this.sourceFileClass = null;
        }
        return this.sourceFileName;
    }

    protected int getSourceFileLine() {
        return 0;
    }

    @Override
    protected void log(Logger.Level level, String message) {
        if (this.isLogging(level)) {
            String name = this.getSourceFileName();
            if (name != null) {
                int line = this.getSourceFileLine();
                String root = this.getContext().getSourceCodeRoot();
                if (root != null) {
                    String ls = System.lineSeparator();
                    message = message + ls + '\t' + root + name + ":" + line;
                } else {
                    message = "(" + name + ":" + line + "): " + message;
                }
            }
            super.log(level, message);
        }
    }

    protected final boolean shouldLogTarget(String patchId, String targetId) {
        return !patchId.equals(targetId);
    }

    protected final void extendLogPrefixWithTargetLabel(String targetLabel) {
        this.extendLogPrefix("target '" + targetLabel + "'");
    }

    @Override
    protected PatcherAnnotation getActionContext(String patchId, T patch) throws PatchException {
        Set<? extends Annotation> rawAnnotations = patch.getAnnotations();
        PatcherAnnotation annotation = PatcherAnnotation.parse(this.getContext(), rawAnnotations);
        if (annotation == null) {
            annotation = new PatcherAnnotation(this.getDefaultAction(patchId, patch), rawAnnotations);
        }
        return annotation;
    }

    private void logAccessFlags(String item, int oldFlags, int newFlags, boolean keepInterface, boolean ensureInterface, boolean keepImplementation, Logger.Level warningLevel) {
        new AccessFlagLogger(item, oldFlags, newFlags){

            @Override
            protected void log(Logger.Level level, String message) {
                AnnotatableSetPatcher.this.log(level, message);
            }
        }.allFlags(this, keepInterface, ensureInterface, keepImplementation, warningLevel);
    }

    @Override
    protected T onSimpleEdit(T patch, PatcherAnnotation annotation, T target, boolean inPlace) {
        int oldFlags = this.getAccessFlags(target);
        int newFlags = this.getAccessFlags(patch);
        if (inPlace) {
            String item = "edited " + this.getItemLabel();
            this.logAccessFlags(item, oldFlags, newFlags, true, false, true, Logger.Level.WARN);
        } else {
            String item = "renamed " + this.getItemLabel();
            this.logAccessFlags(item, oldFlags, newFlags, false, false, true, Logger.Level.WARN);
        }
        return patch;
    }

    @Override
    protected void onEffectiveReplacement(String id, T patch, T patched, T original, boolean inPlaceEdit) {
        if (!inPlaceEdit) {
            int oldFlags = this.getAccessFlags(original);
            int newFlags = this.getAccessFlags(patched);
            String item = "replaced " + this.getItemLabel();
            this.logAccessFlags(item, oldFlags, newFlags, true, false, false, Logger.Level.WARN);
        }
    }

    protected abstract String getItemLabel();

    protected abstract int getAccessFlags(T var1);

    protected abstract Action getDefaultAction(String var1, T var2) throws PatchException;
}

