/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.logger.Logger;

public abstract class AbstractPatcher<T> {
    private final Context context;
    private final Logger logger;
    private final String baseLogPrefix;
    private String logPrefix;
    private LinkedHashMap<String, T> sourceMap;
    private LinkedHashMap<String, Boolean> targetedMap;
    private LinkedHashMap<String, PatchedItem<T>> patchedMap;

    protected AbstractPatcher(Context context) {
        this.context = context;
        this.logger = context.getLogger();
        this.logPrefix = this.baseLogPrefix = "";
    }

    protected AbstractPatcher(AbstractPatcher<?> parent) {
        this.context = parent.context;
        this.logger = parent.logger;
        this.logPrefix = this.baseLogPrefix = parent.logPrefix;
    }

    protected void clearLogPrefix() {
        this.logPrefix = this.baseLogPrefix;
    }

    protected final void setupLogPrefix(String prefix) {
        this.logPrefix = this.baseLogPrefix + prefix + ": ";
    }

    protected final void extendLogPrefix(String prefixComponent) {
        this.logPrefix = this.logPrefix + prefixComponent + ": ";
    }

    protected void log(Logger.Level level, String message) {
        this.logger.log(level, this.logPrefix + message);
    }

    protected final boolean isLogging(Logger.Level level) {
        return this.logger.isLogging(level);
    }

    public final Collection<T> process(Iterable<? extends T> sourceSet, Iterable<? extends T> patchSet) {
        int sizeHint = 16;
        return this.process(sourceSet, 16, patchSet, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> process(Iterable<? extends T> sourceSet, int sourceSetSizeHint, Iterable<? extends T> patchSet, int patchSetSizeHint) {
        this.sourceMap = new LinkedHashMap(sourceSetSizeHint + patchSetSizeHint);
        this.targetedMap = new LinkedHashMap();
        this.patchedMap = new LinkedHashMap(patchSetSizeHint);
        try {
            String id;
            for (T t : sourceSet) {
                String sourceId = this.getId(t);
                if (this.sourceMap.put(sourceId, t) == null) continue;
                this.setupLogPrefix(sourceId, t, null, null);
                this.log(Logger.Level.ERROR, "duplicate found in source");
            }
            for (T t : patchSet) {
                String patchId = this.getId(t);
                this.setupLogPrefix(patchId, t, t, null);
                try {
                    this.onPatch(patchId, t);
                }
                catch (PatchException e) {
                    this.log(Logger.Level.ERROR, e.getMessage());
                }
            }
            for (Map.Entry entry : this.targetedMap.entrySet()) {
                Object original;
                id = (String)entry.getKey();
                boolean inPlaceEdit = (Boolean)entry.getValue();
                PatchedItem<T> patchedItem = this.patchedMap.get(id);
                if (patchedItem == null) {
                    original = this.sourceMap.remove(id);
                    if (original == null) {
                        throw new AssertionError((Object)"Missing target");
                    }
                    continue;
                }
                original = this.sourceMap.put(id, null);
                if (original == null) {
                    throw new AssertionError((Object)"Missing target");
                }
                this.setupLogPrefix(id, patchedItem.patch, patchedItem.patch, patchedItem.patched);
                try {
                    this.onEffectiveReplacement(id, patchedItem.patch, patchedItem.patched, original, inPlaceEdit);
                }
                catch (PatchException e) {
                    this.log(Logger.Level.ERROR, e.getMessage());
                }
            }
            for (Map.Entry entry : this.patchedMap.entrySet()) {
                id = (String)entry.getKey();
                PatchedItem patchedItem = (PatchedItem)entry.getValue();
                if (this.sourceMap.put(id, patchedItem.patched) == null) continue;
                this.setupLogPrefix(id, patchedItem.patch, patchedItem.patch, patchedItem.patched);
                this.log(Logger.Level.ERROR, "already exists");
            }
            Collection<T> collection = this.sourceMap.values();
            return collection;
        }
        finally {
            this.sourceMap = null;
            this.targetedMap = null;
            this.patchedMap = null;
            this.clearLogPrefix();
        }
    }

    protected final Context getContext() {
        return this.context;
    }

    protected final Map<String, T> getSourceMap() {
        return this.sourceMap;
    }

    protected final boolean targetExists(String targetId) {
        return this.sourceMap.get(targetId) != null;
    }

    protected final T findTarget(String targetId, boolean inPlaceEdit) throws PatchException {
        T target = this.sourceMap.get(targetId);
        if (target == null) {
            throw new PatchException("target not found");
        }
        this.addTarget(targetId, inPlaceEdit);
        return target;
    }

    protected final void addTarget(String targetId, boolean inPlaceEdit) throws PatchException {
        if (this.targetedMap.put(targetId, inPlaceEdit) != null) {
            throw new PatchException("already targeted");
        }
    }

    protected final void addPatched(T patch, T patched) throws PatchException {
        PatchedItem<T> patchedItem;
        String id = this.getId(patched);
        if (this.patchedMap.put(id, patchedItem = new PatchedItem<T>(patch, patched)) != null) {
            throw new PatchException("already injected");
        }
    }

    protected abstract String getId(T var1);

    protected abstract void setupLogPrefix(String var1, T var2, T var3, T var4);

    protected abstract void onPatch(String var1, T var2) throws PatchException;

    protected void onEffectiveReplacement(String id, T patch, T patched, T original, boolean inPlaceEdit) throws PatchException {
    }

    static class PatchedItem<T> {
        final T patch;
        final T patched;

        PatchedItem(T patch, T patched) {
            this.patch = patch;
            this.patched = patched;
        }
    }
}

