/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.logger;

import java.io.Closeable;
import java.io.Flushable;

public abstract class Logger
implements Flushable,
Closeable {
    private Level logLevel = Level.DEBUG;
    private int[] counts;

    public Logger() {
        this.clearMessageCounts();
    }

    public final void log(Level level, String message) {
        this.log(level, message, null);
    }

    public final void log(Level level, String message, Throwable throwable) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        int n = level.ordinal();
        this.counts[n] = this.counts[n] + 1;
        if (this.isLogging(level)) {
            this.doLog(level, message, throwable);
        }
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public final boolean isLogging(Level level) {
        return level.ordinal() >= this.logLevel.ordinal();
    }

    public int getMessageCount(Level level) {
        return this.counts[level.ordinal()];
    }

    public void clearMessageCounts() {
        this.counts = new int[Level.values().length];
    }

    public boolean hasNotLoggedErrors() {
        int errors = this.getMessageCount(Level.FATAL) + this.getMessageCount(Level.ERROR);
        return errors == 0;
    }

    public void logErrorAndWarningCounts() {
        int errors = this.getMessageCount(Level.FATAL) + this.getMessageCount(Level.ERROR);
        int warnings = this.getMessageCount(Level.WARN);
        this.log(Level.NONE, errors + " error(s), " + warnings + " warning(s)");
    }

    protected abstract void doLog(Level var1, String var2, Throwable var3);

    @Override
    public abstract void flush();

    @Override
    public abstract void close();

    public static enum Level {
        DEBUG("debug"),
        INFO("info"),
        WARN("warning"),
        ERROR("error"),
        FATAL("fatal"),
        NONE("none");

        private final String label;

        private Level(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

