/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.Marker;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.patcher.ActionBasedPatcher;
import lanchon.dexpatcher.core.util.DexUtils;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;

public class PatcherAnnotation
implements ActionBasedPatcher.ActionContext {
    private final Action action;
    private final String target;
    private final String targetClass;
    private final Action staticConstructorAction;
    private final Action defaultAction;
    private final boolean contentOnly;
    private final boolean recursive;
    private final Set<? extends Annotation> filteredAnnotations;

    private static Action parseActionEnum(EncodedValue value) {
        String s = ((EnumEncodedValue)value).getValue().getName();
        if ("UNDEFINED".equals(s)) {
            return null;
        }
        return Action.valueOf(s);
    }

    /*
     * WARNING - void declaration
     */
    public static PatcherAnnotation parse(Context context, Set<? extends Annotation> annotations) throws PatchException {
        void var6_8;
        Annotation annotation = null;
        Action action = null;
        LinkedHashSet<Annotation> filteredAnnotations = new LinkedHashSet<Annotation>(annotations.size());
        for (Annotation annotation2 : annotations) {
            Action ac = context.getActionFromMarkerTypeDescriptor(annotation2.getType());
            if (ac != null) {
                if (action != null) {
                    throw new PatchException("conflicting patcher annotations (" + action.getMarker().getClassName() + ", " + ac.getMarker().getClassName() + ")");
                }
                action = ac;
                annotation = annotation2;
                continue;
            }
            filteredAnnotations.add(annotation2);
        }
        if (action == null) {
            return null;
        }
        String target = null;
        Object var6_7 = null;
        Action staticConstructorAction = null;
        Action defaultAction = null;
        boolean contentOnly = false;
        boolean recursive = false;
        block18: for (AnnotationElement annotationElement : annotation.getElements()) {
            String name = annotationElement.getName();
            EncodedValue value = annotationElement.getValue();
            switch (name) {
                case "target": {
                    if (target != null) break;
                    String s = ((StringEncodedValue)value).getValue();
                    if (s.length() == 0) continue block18;
                    target = s;
                    continue block18;
                }
                case "targetClass": {
                    if (var6_8 != null) break;
                    String s = ((TypeEncodedValue)value).getValue();
                    if ("V".equals(s)) continue block18;
                    if (!DexUtils.isClassDescriptor(s)) {
                        throw PatcherAnnotation.invalidElement(name);
                    }
                    String string = s;
                    continue block18;
                }
                case "staticConstructorAction": {
                    if (staticConstructorAction != null) break;
                    staticConstructorAction = PatcherAnnotation.parseActionEnum(value);
                    continue block18;
                }
                case "defaultAction": {
                    if (defaultAction != null) break;
                    defaultAction = PatcherAnnotation.parseActionEnum(value);
                    continue block18;
                }
                case "onlyEditMembers": 
                case "contentOnly": {
                    if (contentOnly) break;
                    contentOnly = ((BooleanEncodedValue)value).getValue();
                    continue block18;
                }
                case "recursive": {
                    if (recursive) break;
                    recursive = ((BooleanEncodedValue)value).getValue();
                    continue block18;
                }
            }
            throw PatcherAnnotation.invalidElement(name);
        }
        if (target != null && var6_8 != null) {
            throw new PatchException("conflicting patcher annotation elements (target, targetClass)");
        }
        return new PatcherAnnotation(action, target, (String)var6_8, staticConstructorAction, defaultAction, contentOnly, recursive, Collections.unmodifiableSet(filteredAnnotations));
    }

    public static PatchException invalidAnnotation(Marker marker) {
        return new PatchException("invalid patcher annotation (" + marker.getClassName() + ")");
    }

    public static PatchException invalidElement(String name) {
        return new PatchException("invalid patcher annotation element (" + name + ")");
    }

    public PatcherAnnotation(Action action, Set<? extends Annotation> filteredAnnotations) {
        this(action, null, null, null, null, false, false, filteredAnnotations);
    }

    public PatcherAnnotation(Action action, String target, String targetClass, Action staticConstructorAction, Action defaultAction, boolean contentOnly, boolean recursive, Set<? extends Annotation> filteredAnnotations) {
        if (action == null) {
            throw new AssertionError((Object)"Null action");
        }
        this.action = action;
        this.target = target;
        this.targetClass = targetClass;
        this.staticConstructorAction = staticConstructorAction;
        this.defaultAction = defaultAction;
        this.contentOnly = contentOnly;
        this.recursive = recursive;
        this.filteredAnnotations = filteredAnnotations;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public Action getStaticConstructorAction() {
        return this.staticConstructorAction;
    }

    public Action getDefaultAction() {
        return this.defaultAction;
    }

    public boolean getContentOnly() {
        return this.contentOnly;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public Set<? extends Annotation> getFilteredAnnotations() {
        return this.filteredAnnotations;
    }
}

