/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher;

import java.util.List;
import lanchon.dexpatcher.Configuration;
import lanchon.dexpatcher.Main;
import lanchon.dexpatcher.core.logger.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Parser {
    public static Configuration parseCommandLine(String[] args) throws ParseException {
        Number maxDexPoolSize;
        Number multiDexJobs;
        Configuration config = new Configuration();
        Options options = Parser.getOptions();
        CommandLine cl = new PosixParser().parse(options, args);
        if (cl.hasOption("help")) {
            Parser.printUsage();
            return null;
        }
        if (cl.hasOption("version")) {
            System.out.println(Main.getVersion());
            return null;
        }
        List files = cl.getArgList();
        if (files.isEmpty()) {
            throw new ParseException("Missing argument: <source-dex-apk-or-dir>");
        }
        config.sourceFile = (String)files.remove(0);
        config.patchFiles = files;
        config.patchedFile = cl.getOptionValue("output");
        Number apiLevel = (Number)cl.getParsedOptionValue("api-level");
        if (apiLevel != null) {
            config.apiLevel = apiLevel.intValue();
        }
        config.multiDex = cl.hasOption("multi-dex");
        if (cl.hasOption("multi-dex-threaded")) {
            config.multiDex = true;
            config.multiDexJobs = 0;
        }
        if ((multiDexJobs = (Number)cl.getParsedOptionValue("multi-dex-jobs")) != null) {
            config.multiDex = true;
            config.multiDexJobs = multiDexJobs.intValue();
        }
        if ((maxDexPoolSize = (Number)cl.getParsedOptionValue("max-dex-pool-size")) != null) {
            config.maxDexPoolSize = maxDexPoolSize.intValue();
        }
        config.annotationPackage = cl.getOptionValue("annotations", "lanchon.dexpatcher.annotation");
        config.constructorAutoIgnoreDisabled = cl.hasOption("no-auto-ignore");
        config.logLevel = Logger.Level.WARN;
        if (cl.hasOption("quiet")) {
            config.logLevel = Logger.Level.ERROR;
        }
        if (cl.hasOption("verbose")) {
            config.logLevel = Logger.Level.INFO;
        }
        if (cl.hasOption("debug")) {
            config.logLevel = Logger.Level.DEBUG;
        }
        if (cl.hasOption("path")) {
            config.sourceCodeRoot = "";
        }
        config.sourceCodeRoot = cl.getOptionValue("path-root", config.sourceCodeRoot);
        config.timingStats = cl.hasOption("stats");
        config.dryRun = cl.hasOption("dry-run");
        return config;
    }

    public static void printUsage() {
        System.out.println(Main.getHeader());
        String usage = "dexpatcher [<option> ...] [--output <patched-dex-or-dir>] <source-dex-apk-or-dir> [<patch-dex-apk-or-dir> ...]";
        new HelpFormatter().printHelp(usage, Parser.getOptions());
    }

    private static Options getOptions() {
        Options options = new Options();
        Option o = new Option("o", "output", true, "name of output file or directory");
        o.setArgName("dex-or-dir");
        options.addOption(o);
        o = new Option("a", "api-level", true, "android api level (default: auto-detect)");
        o.setArgName("n");
        o.setType(Number.class);
        options.addOption(o);
        options.addOption(new Option("m", "multi-dex", false, "enable multi-dex support"));
        options.addOption(new Option("M", "multi-dex-threaded", false, "multi-threaded multi-dex (implies: -m)"));
        o = new Option("J", "multi-dex-jobs", true, "multi-dex thread count (implies: -m -M) (default: available processors up to 4)");
        o.setArgName("n");
        o.setType(Number.class);
        options.addOption(o);
        o = new Option(null, "max-dex-pool-size", true, "maximum size of dex pools (default: 65536)");
        o.setArgName("n");
        o.setType(Number.class);
        options.addOption(o);
        o = new Option(null, "annotations", true, "package name of DexPatcher annotations (default: 'lanchon.dexpatcher.annotation')");
        o.setArgName("package");
        options.addOption(o);
        options.addOption(new Option(null, "no-auto-ignore", false, "no trivial default constructor auto-ignore"));
        options.addOption(new Option("q", "quiet", false, "do not output warnings"));
        options.addOption(new Option("v", "verbose", false, "output extra information"));
        options.addOption(new Option(null, "debug", false, "output debugging information"));
        options.addOption(new Option("p", "path", false, "output relative paths of source code files"));
        o = new Option("P", "path-root", true, "output absolute paths of source code files");
        o.setArgName("root");
        options.addOption(o);
        options.addOption(new Option(null, "stats", false, "output timing statistics"));
        options.addOption(new Option(null, "dry-run", false, "do not write output files (much faster)"));
        options.addOption(new Option(null, "version", false, "print version information and exit"));
        options.addOption(new Option("?", "help", false, "print this help message and exit"));
        return options;
    }

    private Parser() {
    }
}

