/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import net.cqure.AuditRule;
import net.cqure.AuditRuleBase;
import net.cqure.SimpleLogger;
import net.cqure.TestEngine;

public class TestEngineJDBC
extends TestEngine {
    private String m_strUrl = "";

    public TestEngineJDBC(String strDriver, String strUrl) throws ClassNotFoundException {
        this.m_strUrl = strUrl;
        Class.forName(strDriver);
    }

    @Override
    public int testPassword(String strUsername, String strPassword) {
        Connection oConnection = null;
        AuditRule oRule = null;
        try {
            System.out.println("[" + new Date().toString() + "] Testing user: " + strUsername + ", pass: " + strPassword);
            oConnection = DriverManager.getConnection(this.m_strUrl, strUsername, strPassword);
            oConnection.close();
            SimpleLogger.getInstance().logDebug("Success: " + strUsername + "/" + strPassword);
            return 1000;
        }
        catch (SQLException e) {
            oRule = AuditRuleBase.getInstance().getAuditRuleForErrorCode(e.getErrorCode());
            if (oRule == null || oRule.isPrint()) {
                SimpleLogger.getInstance().logError("message: " + e.getMessage() + ", code: " + e.getErrorCode());
            } else if (oRule.isAbort()) {
                SimpleLogger.getInstance().logError("message: " + e.getMessage() + ", code: " + e.getErrorCode());
                System.exit(-1);
            } else {
                if (oRule.isIgnore()) {
                    return 1001;
                }
                if (oRule.isLocked()) {
                    System.out.println("[" + new Date().toString() + "] User: " + strUsername + " is LOCKED");
                    return 1002;
                }
            }
            return 1001;
        }
    }
}

