/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import java.util.Hashtable;
import java.util.StringTokenizer;
import net.cqure.exceptions.DriverAliasException;

public class DriverAlias {
    private String m_strAlias = "";
    private String m_strDriver = "";
    private String m_strUrl = "";
    private Hashtable<String, String> m_oOptions = new Hashtable();

    public DriverAlias(String strAlias, String strDriver, String strUrl, String strOptions) throws DriverAliasException {
        StringTokenizer oSTOuter = null;
        StringTokenizer oSTInner = null;
        this.m_strAlias = strAlias;
        this.m_strDriver = strDriver;
        this.m_strUrl = strUrl;
        oSTOuter = new StringTokenizer(strOptions, ",");
        while (oSTOuter.hasMoreElements()) {
            oSTInner = new StringTokenizer(oSTOuter.nextToken(), "=");
            if (2 != oSTInner.countTokens()) {
                throw new DriverAliasException("Inproper options supplied: " + strOptions);
            }
            this.m_oOptions.put(oSTInner.nextToken(), oSTInner.nextToken());
        }
    }

    public String getAlias() {
        return this.m_strAlias;
    }

    public String getDriver() {
        return this.m_strDriver;
    }

    public String toString() {
        return String.valueOf(this.m_strAlias) + " - " + this.m_strDriver;
    }

    public String getOption(String strKey) {
        return this.m_oOptions.get(strKey);
    }

    public String getUrl(String strServer, String strDB, String strPort) throws DriverAliasException {
        String strUrl = this.m_strUrl;
        if (strServer == null) {
            throw new DriverAliasException("Host cannot be null");
        }
        if (strDB == null) {
            throw new DriverAliasException("Database cannot be null");
        }
        strUrl = strUrl.replaceAll("%server%", strServer);
        strUrl = strUrl.replaceAll("%database%", strDB);
        if (strPort == null && this.m_oOptions.get("port") == null) {
            throw new DriverAliasException("No port was given, and no default option was found");
        }
        if (strPort == null) {
            strUrl = strUrl.replaceAll("%port%", this.m_oOptions.get("port"));
        }
        return strUrl;
    }
}

