/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import gnu.getopt.Getopt;
import java.io.IOException;
import java.util.Date;
import net.cqure.AuditObject;
import net.cqure.AuditQueue;
import net.cqure.AuditRuleBase;
import net.cqure.DriverAlias;
import net.cqure.DriverAliasList;
import net.cqure.FileList;
import net.cqure.ShutdownThread;
import net.cqure.SimpleLogger;
import net.cqure.TestEngineJDBC;
import net.cqure.TestManager;
import net.cqure.TestThread;
import net.cqure.exceptions.AuditRuleException;
import net.cqure.exceptions.DriverAliasException;

public class DBPwAudit {
    private static AuditQueue m_oQueue = new AuditQueue();
    private static TestManager m_oManager = null;
    private static final String m_strProgram = "DBPwAudit";
    private static final String m_strVersion = "0.8";
    private static final String m_strAuthor = "patrik@cqure.net";
    private static final String m_strAliases = "aliases.conf";
    private static String server;
    private static String alias;
    public static boolean _finnished;

    static {
        _finnished = false;
    }

    public static void printResults() {
        String strHeader = "Results for password scan against " + server + " using provider " + alias;
        if (m_oManager == null) {
            return;
        }
        System.out.println("");
        System.out.println(strHeader);
        int i = 0;
        while (i < strHeader.length()) {
            System.out.print("-");
            ++i;
        }
        System.out.println("");
        i = 0;
        while (i < m_oQueue.size()) {
            String str = ((AuditObject)m_oQueue.get(i)).toString();
            if (str != null) {
                System.out.println(str);
            }
            ++i;
        }
        System.out.println();
        System.out.print("Tested " + TestThread.getTestCount() + " passwords in " + (float)m_oManager.getElapsedTime() / 1000.0f + " seconds");
        System.out.println(" (" + (float)TestThread.getTestCount() / ((float)m_oManager.getElapsedTime() / 1000.0f) + "tries/sec)");
    }

    private static void banner() {
        String strBanner = "DBPwAudit v0.8 by Patrik Karlsson <patrik@cqure.net>";
        System.out.println(strBanner);
        int i = 0;
        while (i < strBanner.length()) {
            System.out.print("-");
            ++i;
        }
        System.out.println();
    }

    private static void usage() {
        System.out.println("DBPwAudit -s <server> -d <db> -D <driver> -U <users> -P <passwords> [options]");
        System.out.println();
        System.out.println("\t-s - Server name or address.");
        System.out.println("\t-p - Port of database server/instance.");
        System.out.println("\t-d - Database/Instance name to audit.");
        System.out.println("\t-D - The alias of the driver to use (-L for aliases)");
        System.out.println("\t-U - File containing usernames to guess.");
        System.out.println("\t-P - File containing passwords to guess.");
        System.out.println("\t-L - List driver aliases.");
        System.out.println();
    }

    private static boolean loadAuditRules(String strDriver) {
        try {
            AuditRuleBase.getInstance().setDriver(strDriver);
            AuditRuleBase.getInstance().loadRuleBase("rules.conf");
        }
        catch (AuditRuleException e1) {
            System.err.println(e1.getMessage());
            return false;
        }
        return true;
    }

    private static void listDriverAliases() {
        DriverAliasList oList = null;
        try {
            oList = new DriverAliasList(m_strAliases);
            oList.printDrivers();
        }
        catch (DriverAliasException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        FileList oUserList = null;
        FileList oPassList = null;
        TestEngineJDBC oEngine = null;
        DriverAliasList oList = null;
        DriverAlias oAlias = null;
        String strDriver = null;
        String strUrl = null;
        String strUserfile = null;
        String strPassfile = null;
        String strPort = null;
        String strDb = null;
        Getopt oOpt = new Getopt("pwaudit", args, "D:U:P:s:p:d:hvL");
        int c = -1;
        DBPwAudit.banner();
        while ((c = oOpt.getopt()) != -1) {
            switch (c) {
                case 68: {
                    alias = oOpt.getOptarg();
                    break;
                }
                case 85: {
                    strUserfile = oOpt.getOptarg();
                    break;
                }
                case 80: {
                    strPassfile = oOpt.getOptarg();
                    break;
                }
                case 118: {
                    SimpleLogger.getInstance().setLogDebug();
                    break;
                }
                case 76: {
                    DBPwAudit.listDriverAliases();
                    System.exit(1);
                }
                case 112: {
                    strPort = oOpt.getOptarg();
                    break;
                }
                case 115: {
                    server = oOpt.getOptarg();
                    break;
                }
                case 100: {
                    strDb = oOpt.getOptarg();
                    break;
                }
                case 104: {
                    DBPwAudit.usage();
                    System.exit(1);
                }
                default: {
                    System.exit(1);
                }
            }
        }
        if (alias == null || strUserfile == null || strPassfile == null || strDb == null) {
            DBPwAudit.usage();
            System.exit(1);
        }
        try {
            oList = new DriverAliasList(m_strAliases);
            oAlias = oList.getDriverAlias(alias);
            strDriver = oAlias.getDriver();
            strUrl = oAlias.getUrl(server, strDb, strPort);
        }
        catch (DriverAliasException e) {
            System.err.println("Failed to load driver for alias \"" + alias + "\"");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        if (!DBPwAudit.loadAuditRules(strDriver)) {
            SimpleLogger.getInstance().logInfo("Failed to load audit rules for driver");
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(m_oQueue));
        try {
            oEngine = new TestEngineJDBC(strDriver, strUrl);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Failed to load driver: " + strDriver);
            _finnished = true;
            return;
        }
        try {
            oUserList = new FileList(strUserfile);
        }
        catch (IOException e) {
            System.err.println("Failed to load userfile: " + strUserfile);
            _finnished = true;
            return;
        }
        try {
            oPassList = new FileList(strPassfile);
        }
        catch (IOException e) {
            System.err.println("Failed to load passwordfile: " + strPassfile);
            _finnished = true;
            return;
        }
        int i = 0;
        while (i < oUserList.size()) {
            m_oQueue.add(new AuditObject((String)oUserList.get(i), oPassList));
            ++i;
        }
        System.out.println("[" + new Date().toString() + "] Starting password audit ...");
        m_oManager = new TestManager(m_oQueue, oEngine);
        m_oManager.startTest();
        System.out.println("[" + new Date().toString() + "] Finnishing password audit ...");
        _finnished = true;
    }
}

