/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.cqure.AuditRule;
import net.cqure.FileList;
import net.cqure.exceptions.AuditRuleException;

public class AuditRuleBase
extends Vector<AuditRule> {
    private static final long serialVersionUID = 4954697778075414363L;
    private String m_strDriver = null;
    private static AuditRuleBase _instance = new AuditRuleBase();

    private AuditRuleBase() {
    }

    public void setDriver(String strDriver) {
        this.m_strDriver = strDriver;
    }

    public static AuditRuleBase getInstance() {
        return _instance;
    }

    public void loadRuleBase(String strFilename) throws AuditRuleException {
        FileList oList = null;
        Pattern oPattern = Pattern.compile("(.+);(.+);(.+)");
        String strLine = "";
        if (this.m_strDriver == null) {
            throw new AuditRuleException("Driver not set");
        }
        try {
            oList = new FileList(strFilename);
        }
        catch (IOException e) {
            throw new AuditRuleException("Failed to load rulebase from " + strFilename);
        }
        int i = 0;
        while (i < oList.size()) {
            strLine = ((String)oList.get(i)).trim();
            if (strLine.length() != 0 && !strLine.startsWith("//")) {
                Matcher oMatcher = oPattern.matcher(strLine);
                if (!oMatcher.matches() && 4 != oMatcher.groupCount()) {
                    throw new AuditRuleException("Invalid rule: " + strLine);
                }
                try {
                    if (this.m_strDriver.equalsIgnoreCase(oMatcher.group(1)) || oMatcher.group(1).equals("*")) {
                        this.add(new AuditRule(Integer.parseInt(oMatcher.group(2)), oMatcher.group(3)));
                    }
                }
                catch (NumberFormatException e) {
                    throw new AuditRuleException("Invalid rule: " + strLine + "\nError code has to be numeric");
                }
            }
            ++i;
        }
    }

    public void printRuleBase() {
        int i = 0;
        while (i < this.size()) {
            System.out.println(((AuditRule)this.get(i)).toString());
            ++i;
        }
    }

    public AuditRule getAuditRuleForErrorCode(int nErrorCode) {
        int i = 0;
        while (i < this.size()) {
            if (((AuditRule)this.get(i)).isCatchAll() || ((AuditRule)this.get(i)).isMatch(nErrorCode)) {
                return (AuditRule)this.get(i);
            }
            ++i;
        }
        return null;
    }
}

