/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

public class W32WinInet {
    public static int PROXY_TYPE_DIRECT = 1;
    public static int PROXY_TYPE_PROXY = 2;
    public static int PROXY_TYPE_AUTO_PROXY_URL = 4;
    public static int PROXY_TYPE_AUTO_DETECT = 8;
    private static boolean _available = false;
    private static boolean _intercepted = false;
    private static long _perConn = 0L;
    private static String _proxyServer = null;
    private static String _proxyBypass = null;

    static {
        try {
            System.loadLibrary("W32WinInet");
            if (W32WinInet.testLibraryLoad() == 1) {
                _available = true;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            _available = false;
        }
    }

    private static native int testLibraryLoad();

    private static native long getInternetPerConnFlags();

    private static native long getAutoDiscoveryFlags();

    private static native String getAutoConfigUrl();

    private static native String getProxyServer();

    private static native String getProxyBypass();

    private static native int setProxy(long var0, String var2, String var3);

    public static boolean isAvailable() {
        return _available;
    }

    public static boolean interceptProxy(String server, int port) {
        int result;
        if (!W32WinInet.isAvailable()) {
            return false;
        }
        if (!_intercepted) {
            _perConn = W32WinInet.getInternetPerConnFlags();
            _proxyServer = W32WinInet.getProxyServer();
            _proxyBypass = W32WinInet.getProxyBypass();
        }
        if ((result = W32WinInet.setProxy(PROXY_TYPE_PROXY, String.valueOf(server) + ":" + port, null)) != 0) {
            result = W32WinInet.setProxy(_perConn, _proxyServer, _proxyBypass);
            return false;
        }
        _intercepted = true;
        return true;
    }

    public static void revertProxy() {
        if (!_intercepted) {
            return;
        }
        int result = W32WinInet.setProxy(_perConn, _proxyServer, _proxyBypass);
        _intercepted = false;
    }

    private static String getProxy(String type) {
        String proxy = _intercepted ? _proxyServer : W32WinInet.getProxyServer();
        if (proxy == null) {
            return null;
        }
        if (proxy.indexOf("=") <= 0) {
            return proxy;
        }
        String[] proxies = proxy.split(";");
        int i = 0;
        while (i < proxies.length) {
            if (proxies[i].startsWith(String.valueOf(type) + "=")) {
                return proxies[i].substring(proxies[i].indexOf("=") + 1);
            }
            ++i;
        }
        return null;
    }

    public static String getHttpProxyServer() {
        String proxy = W32WinInet.getProxy("http");
        if (proxy == null) {
            return null;
        }
        return proxy.substring(0, proxy.indexOf(":"));
    }

    public static int getHttpProxyPort() {
        String proxy = W32WinInet.getProxy("http");
        if (proxy == null) {
            return -1;
        }
        try {
            return Integer.parseInt(proxy.substring(proxy.indexOf(":") + 1));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static String getHttpsProxyServer() {
        String proxy = W32WinInet.getProxy("https");
        if (proxy == null) {
            return null;
        }
        return proxy.substring(0, proxy.indexOf(":"));
    }

    public static int getHttpsProxyPort() {
        String proxy = W32WinInet.getProxy("https");
        if (proxy == null) {
            return -1;
        }
        try {
            return Integer.parseInt(proxy.substring(proxy.indexOf(":") + 1));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static String getNoProxy() {
        String bypass = !_intercepted ? W32WinInet.getProxyBypass() : _proxyBypass;
        if (bypass == null) {
            return null;
        }
        return bypass;
    }

    public static void main(String[] args) throws Exception {
        if (!W32WinInet.isAvailable()) {
            System.err.println("DLL not found, or wrong platform!");
            System.exit(1);
        }
        if (args.length == 0) {
            System.err.println("Please specify an address to set temporarily");
            System.err.println("e.g. W32WinInet localhost:3128");
        }
        long perConn = W32WinInet.getInternetPerConnFlags();
        String proxyServer = W32WinInet.getProxyServer();
        String proxyBypass = W32WinInet.getProxyBypass();
        System.out.println("Current settings:");
        System.out.println("PerConnFlags: " + perConn);
        System.out.println("ProxyServer: " + proxyServer);
        System.out.println("ProxyBypass: " + proxyBypass);
        System.out.println();
        System.out.println("Changed to " + args[0] + ", result is : " + W32WinInet.setProxy(PROXY_TYPE_PROXY, args[0], null));
        System.out.println("Settings are now:");
        System.out.println("PerConnFlags: " + W32WinInet.getInternetPerConnFlags());
        System.out.println("ProxyServer: " + W32WinInet.getProxyServer());
        System.out.println("ProxyBypass: " + W32WinInet.getProxyBypass());
        System.out.print("Press enter to change them back: ");
        System.in.read();
        System.out.println("Result is : " + W32WinInet.setProxy(perConn, proxyServer, proxyBypass));
        System.out.println();
        System.out.println("Current settings:");
        System.out.println("PerConnFlags: " + W32WinInet.getInternetPerConnFlags());
        System.out.println("ProxyServer: " + W32WinInet.getProxyServer());
        System.out.println("ProxyBypass: " + W32WinInet.getProxyBypass());
    }
}

