/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

import java.util.HashMap;
import java.util.Map;

public class HtmlEncoder {
    static Map e2i = new HashMap();
    static Map i2e = new HashMap();
    private static Object[][] entities = new Object[][]{{"quot", new Integer(34)}, {"amp", new Integer(38)}, {"lt", new Integer(60)}, {"gt", new Integer(62)}, {"nbsp", new Integer(160)}, {"copy", new Integer(169)}, {"reg", new Integer(174)}, {"Agrave", new Integer(192)}, {"Aacute", new Integer(193)}, {"Acirc", new Integer(194)}, {"Atilde", new Integer(195)}, {"Auml", new Integer(196)}, {"Aring", new Integer(197)}, {"AElig", new Integer(198)}, {"Ccedil", new Integer(199)}, {"Egrave", new Integer(200)}, {"Eacute", new Integer(201)}, {"Ecirc", new Integer(202)}, {"Euml", new Integer(203)}, {"Igrave", new Integer(204)}, {"Iacute", new Integer(205)}, {"Icirc", new Integer(206)}, {"Iuml", new Integer(207)}, {"ETH", new Integer(208)}, {"Ntilde", new Integer(209)}, {"Ograve", new Integer(210)}, {"Oacute", new Integer(211)}, {"Ocirc", new Integer(212)}, {"Otilde", new Integer(213)}, {"Ouml", new Integer(214)}, {"Oslash", new Integer(216)}, {"Ugrave", new Integer(217)}, {"Uacute", new Integer(218)}, {"Ucirc", new Integer(219)}, {"Uuml", new Integer(220)}, {"Yacute", new Integer(221)}, {"THORN", new Integer(222)}, {"szlig", new Integer(223)}, {"agrave", new Integer(224)}, {"aacute", new Integer(225)}, {"acirc", new Integer(226)}, {"atilde", new Integer(227)}, {"auml", new Integer(228)}, {"aring", new Integer(229)}, {"aelig", new Integer(230)}, {"ccedil", new Integer(231)}, {"egrave", new Integer(232)}, {"eacute", new Integer(233)}, {"ecirc", new Integer(234)}, {"euml", new Integer(235)}, {"igrave", new Integer(236)}, {"iacute", new Integer(237)}, {"icirc", new Integer(238)}, {"iuml", new Integer(239)}, {"igrave", new Integer(236)}, {"iacute", new Integer(237)}, {"icirc", new Integer(238)}, {"iuml", new Integer(239)}, {"eth", new Integer(240)}, {"ntilde", new Integer(241)}, {"ograve", new Integer(242)}, {"oacute", new Integer(243)}, {"ocirc", new Integer(244)}, {"otilde", new Integer(245)}, {"ouml", new Integer(246)}, {"oslash", new Integer(248)}, {"ugrave", new Integer(249)}, {"uacute", new Integer(250)}, {"ucirc", new Integer(251)}, {"uuml", new Integer(252)}, {"yacute", new Integer(253)}, {"thorn", new Integer(254)}, {"yuml", new Integer(255)}, {"euro", new Integer(8364)}};

    public HtmlEncoder() {
        int i = 0;
        while (i < entities.length) {
            e2i.put(entities[i][0], entities[i][1]);
            ++i;
        }
        i = 0;
        while (i < entities.length) {
            i2e.put(entities[i][1], entities[i][0]);
            ++i;
        }
    }

    public static String encode(String s1) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s1.length()) {
            char ch = s1.charAt(i);
            String entity = (String)i2e.get(new Integer(ch));
            if (entity == null) {
                if (ch > '\u0080') {
                    buf.append("&#" + ch + ";");
                } else {
                    buf.append(ch);
                }
            } else {
                buf.append("&" + entity + ";");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String decode(String s1) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s1.length()) {
            char ch = s1.charAt(i);
            if (ch == '&') {
                int semi = s1.indexOf(59, i + 1);
                if (semi == -1) {
                    buf.append(ch);
                } else {
                    String entity = s1.substring(i + 1, semi);
                    Integer iso = entity.charAt(0) == '#' ? new Integer(entity.substring(1)) : (Integer)e2i.get(entity);
                    if (iso == null) {
                        buf.append("&" + entity + ";");
                    } else {
                        buf.append((char)iso.intValue());
                    }
                    i = semi;
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

