/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.UrlEvent;
import org.owasp.webscarab.model.UrlListener;
import org.owasp.webscarab.model.UrlModel;

public abstract class AbstractUrlModel
implements UrlModel {
    private EventListenerList _listenerList = new EventListenerList();
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    @Override
    public abstract int getChildCount(HttpUrl var1);

    @Override
    public abstract int getIndexOf(HttpUrl var1);

    @Override
    public abstract HttpUrl getChildAt(HttpUrl var1, int var2);

    @Override
    public abstract Sync readLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUrlListener(UrlListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.add(UrlListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUrlListener(UrlListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.remove(UrlListener.class, listener);
        }
    }

    protected void fireUrlAdded(HttpUrl url, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        UrlEvent evt = new UrlEvent(this, url, position);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == UrlListener.class) {
                try {
                    ((UrlListener)listeners[i + 1]).urlAdded(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                    e.printStackTrace();
                }
            }
            i -= 2;
        }
    }

    protected void fireUrlRemoved(HttpUrl url, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        UrlEvent evt = new UrlEvent(this, url, position);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == UrlListener.class) {
                try {
                    ((UrlListener)listeners[i + 1]).urlRemoved(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireUrlChanged(HttpUrl url, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        UrlEvent evt = new UrlEvent(this, url, position);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == UrlListener.class) {
                try {
                    ((UrlListener)listeners[i + 1]).urlChanged(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                    e.printStackTrace();
                }
            }
            i -= 2;
        }
    }

    protected void fireUrlsChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == UrlListener.class) {
                try {
                    ((UrlListener)listeners[i + 1]).urlsChanged();
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                    e.printStackTrace();
                }
            }
            i -= 2;
        }
    }
}

