/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.httpclient;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.owasp.webscarab.httpclient.Authenticator;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.httpclient.SSLContextManager;
import org.owasp.webscarab.httpclient.URLFetcher;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;

public class HTTPClientFactory {
    private static HTTPClientFactory _instance = new HTTPClientFactory();
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _httpProxy = "";
    private int _httpProxyPort = 80;
    private String _httpsProxy = "";
    private int _httpsProxyPort = 80;
    private String[] _noProxy = new String[0];
    private int _connectTimeout = 30000;
    private int _readTimeout = 0;
    private SSLContextManager _sslContextManager = null;
    private String _certFile = "";
    private String _keystorePassword = "";
    private String _keyPassword = "";
    private Authenticator _authenticator = null;
    private KeyManager[] _keyManagers = null;
    private List _clientList = new ArrayList();
    private List _availableClients = new ArrayList();
    private static TrustManager[] _trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    protected HTTPClientFactory() {
        this._sslContextManager = new SSLContextManager();
    }

    public static HTTPClientFactory getInstance() {
        return _instance;
    }

    public SSLContextManager getSSLContextManager() {
        return this._sslContextManager;
    }

    public void setHttpProxy(String proxy, int port) {
        if (proxy == null) {
            proxy = "";
        }
        this._httpProxy = proxy;
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port is out of range: " + port);
        }
        this._httpProxyPort = port;
    }

    public String getHttpProxy() {
        return this._httpProxy;
    }

    public int getHttpProxyPort() {
        return this._httpProxyPort;
    }

    public void setHttpsProxy(String proxy, int port) {
        if (proxy == null) {
            proxy = "";
        }
        this._httpsProxy = proxy;
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port is out of range: " + port);
        }
        this._httpsProxyPort = port;
    }

    public String getHttpsProxy() {
        return this._httpsProxy;
    }

    public int getHttpsProxyPort() {
        return this._httpsProxyPort;
    }

    public void setNoProxy(String[] noProxy) {
        this._noProxy = noProxy;
        if (this._noProxy == null) {
            this._noProxy = new String[0];
        }
    }

    public String[] getNoProxy() {
        return this._noProxy;
    }

    public void setTimeouts(int connectTimeout, int readTimeout) {
        this._connectTimeout = connectTimeout;
        this._readTimeout = readTimeout;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public HTTPClient getHTTPClient() {
        URLFetcher uf = new URLFetcher();
        uf.setHttpProxy(this._httpProxy, this._httpProxyPort);
        uf.setHttpsProxy(this._httpsProxy, this._httpsProxyPort);
        uf.setNoProxy(this._noProxy);
        uf.setSSLContextManager(this._sslContextManager);
        uf.setTimeouts(this._connectTimeout, this._readTimeout);
        uf.setAuthenticator(this._authenticator);
        return uf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response fetchResponse(Request request) throws IOException {
        HTTPClient hc = null;
        List list = this._availableClients;
        synchronized (list) {
            if (this._availableClients.size() > 0) {
                hc = (HTTPClient)this._availableClients.remove(0);
            } else {
                this._logger.info("Creating a new Fetcher");
                hc = this.getHTTPClient();
                this._clientList.add(hc);
            }
        }
        Response response = null;
        IOException ioe = null;
        try {
            response = hc.fetchResponse(request);
        }
        catch (IOException e) {
            ioe = e;
        }
        List list2 = this._availableClients;
        synchronized (list2) {
            this._availableClients.add(hc);
        }
        if (ioe != null) {
            throw ioe;
        }
        return response;
    }
}

