/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.httpclient;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    String[][] _trailer = null;
    boolean _writeTrailer = true;

    public ChunkedOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public void setTrailer(String[][] trailer) {
        this._trailer = trailer;
    }

    public void writeTrailer() throws IOException {
        if (!this._writeTrailer) {
            return;
        }
        this.out.write("0\r\n".getBytes());
        if (this._trailer != null) {
            int i = 0;
            while (i < this._trailer.length) {
                if (this._trailer[i].length == 2) {
                    this.out.write((String.valueOf(this._trailer[i][0]) + ": " + this._trailer[i][1] + "\r\n").getBytes());
                }
                ++i;
            }
        }
        this.out.write("\r\n".getBytes());
        this._writeTrailer = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write("1\r\n".getBytes());
        this.out.write(b);
        this.out.write("\r\n".getBytes());
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write((String.valueOf(Integer.toString(len - off, 16)) + "\r\n").getBytes());
        this.out.write(b, off, len);
        this.out.write("\r\n".getBytes());
    }
}

